/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.Objects;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.xpack.esql.core.QlClientException;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class FoldContext {
    private static final long SMALL = MemorySizeValue.parseBytesSizeValueOrHeapRatio((String)"5%", (String)"small").getBytes();
    private final long initialAllowedBytes;
    private long allowedBytes;

    public static FoldContext small() {
        return new FoldContext(SMALL);
    }

    public FoldContext(long allowedBytes) {
        this.initialAllowedBytes = allowedBytes;
        this.allowedBytes = allowedBytes;
    }

    public long initialAllowedBytes() {
        return this.initialAllowedBytes;
    }

    long allowedBytes() {
        return this.allowedBytes;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FoldContext that = (FoldContext)o;
        return this.initialAllowedBytes == that.initialAllowedBytes && this.allowedBytes == that.allowedBytes;
    }

    public int hashCode() {
        return Objects.hash(this.initialAllowedBytes, this.allowedBytes);
    }

    public String toString() {
        return "FoldContext[" + this.allowedBytes + "/" + this.initialAllowedBytes + "]";
    }

    public void trackAllocation(Source source, long bytes) {
        this.allowedBytes -= bytes;
        assert (this.allowedBytes <= this.initialAllowedBytes) : "returned more bytes than it used";
        if (this.allowedBytes < 0L) {
            throw new FoldTooMuchMemoryException(source, bytes, this.initialAllowedBytes);
        }
    }

    public CircuitBreaker circuitBreakerView(final Source source) {
        return new CircuitBreaker(){

            public void circuitBreak(String fieldName, long bytesNeeded) {
                throw new UnsupportedOperationException();
            }

            public void addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
                FoldContext.this.trackAllocation(source, bytes);
            }

            public void addWithoutBreaking(long bytes) {
                assert (bytes <= 0L) : "we only expect this to be used for deallocation";
                FoldContext.this.allowedBytes -= bytes;
                assert (FoldContext.this.allowedBytes <= FoldContext.this.initialAllowedBytes) : "returned more bytes than it used";
            }

            public long getUsed() {
                return FoldContext.this.initialAllowedBytes - FoldContext.this.allowedBytes;
            }

            public long getLimit() {
                return FoldContext.this.initialAllowedBytes;
            }

            public double getOverhead() {
                return 1.0;
            }

            public long getTrippedCount() {
                return 0L;
            }

            public String getName() {
                return "request";
            }

            public CircuitBreaker.Durability getDurability() {
                throw new UnsupportedOperationException();
            }

            public void setLimitAndOverhead(long limit, double overhead) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class FoldTooMuchMemoryException
    extends QlClientException {
        protected FoldTooMuchMemoryException(Source source, long bytesForExpression, long initialAllowedBytes) {
            super("line {}:{}: Folding query used more than {}. The expression that pushed past the limit is [{}] which needed {}.", new Object[]{source.source().getLineNumber(), source.source().getColumnNumber(), ByteSizeValue.ofBytes((long)initialAllowedBytes), source.text(), ByteSizeValue.ofBytes((long)bytesForExpression)});
        }
    }
}

