/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.capabilities;

import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public interface TranslationAware {
    public Translatable translatable(LucenePushdownPredicates var1);

    public static Translatable translatable(Expression exp, LucenePushdownPredicates lucenePushdownPredicates) {
        if (exp instanceof TranslationAware) {
            TranslationAware aware = (TranslationAware)((Object)exp);
            return aware.translatable(lucenePushdownPredicates);
        }
        return Translatable.NO;
    }

    public org.elasticsearch.xpack.esql.core.querydsl.query.Query asQuery(LucenePushdownPredicates var1, TranslatorHandler var2);

    default public Query asLuceneQuery(MappedFieldType fieldType, MultiTermQuery.RewriteMethod constantScoreRewrite, SearchExecutionContext context) {
        throw new UnsupportedOperationException("asLuceneQuery is not implemented for " + this.getClass().getName());
    }

    public static enum Translatable {
        NO(FinishedTranslatable.NO),
        YES(FinishedTranslatable.YES),
        RECHECK(FinishedTranslatable.RECHECK),
        YES_BUT_RECHECK_NEGATED(FinishedTranslatable.YES);

        private final FinishedTranslatable finish;

        private Translatable(FinishedTranslatable finish) {
            this.finish = finish;
        }

        public FinishedTranslatable finish() {
            return this.finish;
        }

        public Translatable negate() {
            if (this == YES_BUT_RECHECK_NEGATED) {
                return RECHECK;
            }
            return this;
        }

        public Translatable merge(Translatable rhs) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NO;
                case 1 -> {
                    switch (rhs.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield NO;
                        }
                        case 1: {
                            yield YES;
                        }
                        case 2: {
                            yield RECHECK;
                        }
                        case 3: 
                    }
                    yield YES_BUT_RECHECK_NEGATED;
                }
                case 2 -> {
                    switch (rhs.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield NO;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                    }
                    yield RECHECK;
                }
                case 3 -> {
                    switch (rhs.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            yield NO;
                        }
                        case 1: 
                        case 3: {
                            yield YES_BUT_RECHECK_NEGATED;
                        }
                        case 2: 
                    }
                    yield RECHECK;
                }
            };
        }
    }

    public static enum FinishedTranslatable {
        YES,
        NO,
        RECHECK;

    }

    public static interface SingleValueTranslationAware
    extends TranslationAware {
        public Expression singleValueField();
    }
}

