/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis.rules;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.AnalyzerRules;
import org.elasticsearch.xpack.esql.analysis.UnmappedResolution;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedPattern;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedTimestamp;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;

public class ResolveUnmapped
extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
    private static final Literal NULLIFIED = Literal.NULL;

    @Override
    protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
        return switch (context.unmappedResolution()) {
            default -> throw new MatchException(null, null);
            case UnmappedResolution.FAIL -> plan;
            case UnmappedResolution.NULLIFY -> ResolveUnmapped.resolve(plan, false);
            case UnmappedResolution.LOAD -> ResolveUnmapped.resolve(plan, true);
        };
    }

    private static LogicalPlan resolve(LogicalPlan plan, boolean load) {
        if (!plan.childrenResolved()) {
            return plan;
        }
        List<UnresolvedAttribute> unresolved = ResolveUnmapped.collectUnresolved(plan);
        if (unresolved.isEmpty()) {
            return plan;
        }
        LogicalPlan transformed = load ? ResolveUnmapped.load(plan, unresolved) : ResolveUnmapped.nullify(plan, unresolved);
        return transformed.equals(plan) ? plan : ResolveUnmapped.refreshPlan(transformed, unresolved);
    }

    private static LogicalPlan nullify(LogicalPlan plan, List<UnresolvedAttribute> unresolved) {
        List<Alias> nullAliases = ResolveUnmapped.nullAliases(unresolved);
        LogicalPlan transformed = plan.transformUp(n -> {
            UnaryPlan unary;
            return n instanceof UnaryPlan && (unary = (UnaryPlan)n).child() instanceof LeafPlan;
        }, p -> ResolveUnmapped.evalUnresolvedUnary((UnaryPlan)p, nullAliases));
        transformed = transformed.transformUp(n -> !(n instanceof UnaryPlan) && !(n instanceof LeafPlan), nAry -> ResolveUnmapped.evalUnresolvedNary(nAry, nullAliases));
        return transformed.transformUp(Fork.class, f -> ResolveUnmapped.patchFork(f, Expressions.asAttributes(nullAliases)));
    }

    private static LogicalPlan load(LogicalPlan plan, List<UnresolvedAttribute> unresolved) {
        LogicalPlan transformed = plan.transformUp(EsRelation.class, esr -> {
            if (esr.indexMode() == IndexMode.LOOKUP) {
                return esr;
            }
            List<FieldAttribute> fieldsToLoad = ResolveUnmapped.fieldsToLoad(unresolved, esr.outputSet().names());
            return fieldsToLoad.isEmpty() ? esr : esr.withAttributes(CollectionUtils.combine(esr.output(), fieldsToLoad));
        });
        return transformed.transformUp(Fork.class, f -> ResolveUnmapped.patchFork(f, Expressions.asAttributes(ResolveUnmapped.fieldsToLoad(unresolved, Set.of()))));
    }

    private static List<FieldAttribute> fieldsToLoad(List<UnresolvedAttribute> unresolved, Set<String> exclude) {
        ArrayList<FieldAttribute> insisted = new ArrayList<FieldAttribute>(unresolved.size());
        LinkedHashSet<String> names = new LinkedHashSet<String>(unresolved.size());
        for (UnresolvedAttribute ua : unresolved) {
            if (names.contains(ua.name()) || exclude.contains(ua.name())) continue;
            insisted.add(Analyzer.ResolveRefs.insistKeyword(ua));
            names.add(ua.name());
        }
        return insisted;
    }

    private static Fork patchFork(Fork fork, List<Attribute> aliasAttributes) {
        aliasAttributes.removeIf(a -> !fork.children().stream().anyMatch(f -> ResolveUnmapped.descendantOutputsAttribute(f, a)));
        if (aliasAttributes.isEmpty()) {
            return fork;
        }
        ArrayList<LogicalPlan> newChildren = new ArrayList<LogicalPlan>(fork.children().size());
        for (LogicalPlan child : fork.children()) {
            Holder patched = new Holder((Object)false);
            child = child.transformDown(n -> (Boolean)patched.get() == false && n instanceof Project, n -> {
                patched.set((Object)true);
                return ResolveUnmapped.patchForkProject((Project)n, aliasAttributes);
            });
            if (!((Boolean)patched.get()).booleanValue()) {
                throw new EsqlIllegalArgumentException("Fork child misses a top projection");
            }
            newChildren.add(child);
        }
        return fork.replaceSubPlansAndOutput(newChildren, CollectionUtils.combine(fork.output(), aliasAttributes));
    }

    private static Project patchForkProject(Project project, List<Attribute> aliasAttributes) {
        aliasAttributes = aliasAttributes.stream().map(a -> a.withId(new NameId())).toList();
        project = project.withProjections(CollectionUtils.combine(project.projections(), aliasAttributes));
        ArrayList<Alias> nullAliases = new ArrayList<Alias>(aliasAttributes.size());
        for (Attribute attribute : aliasAttributes) {
            if (ResolveUnmapped.descendantOutputsAttribute(project, attribute)) continue;
            nullAliases.add(ResolveUnmapped.nullAlias(attribute));
        }
        return nullAliases.isEmpty() ? project : project.replaceChild(new Eval(project.source(), project.child(), nullAliases));
    }

    private static boolean descendantOutputsAttribute(LogicalPlan plan, Attribute attribute) {
        if (plan instanceof Limit) {
            Limit limit = (Limit)plan;
            v0 = limit.child();
        } else {
            v0 = plan = plan;
        }
        if (plan instanceof Project) {
            Project project = (Project)plan;
            return project.child().outputSet().names().contains(attribute.name());
        }
        throw new EsqlIllegalArgumentException("unexpected node type [{}]", plan);
    }

    private static LogicalPlan refreshPlan(LogicalPlan plan, List<UnresolvedAttribute> unresolved) {
        LogicalPlan refreshed = ResolveUnmapped.refreshUnresolved(plan, unresolved);
        return ResolveUnmapped.refreshChildren(refreshed);
    }

    private static LogicalPlan refreshUnresolved(LogicalPlan plan, List<UnresolvedAttribute> unresolved) {
        return (LogicalPlan)plan.transformExpressionsOnlyUp(UnresolvedAttribute.class, ua -> {
            if (unresolved.contains(ua)) {
                unresolved.remove(ua);
                ua = ua.withId(new NameId()).withUnresolvedMessage(null);
            }
            return ua;
        });
    }

    private static LogicalPlan refreshChildren(LogicalPlan plan) {
        List<LogicalPlan> planChildren = plan.children();
        if (planChildren.isEmpty()) {
            return plan;
        }
        ArrayList newChildren = new ArrayList(planChildren.size());
        planChildren.forEach(child -> newChildren.add(ResolveUnmapped.refreshChildren(child)));
        return (LogicalPlan)plan.replaceChildren(newChildren);
    }

    private static LogicalPlan evalUnresolvedNary(LogicalPlan nAry, List<Alias> nullAliases) {
        ArrayList<LogicalPlan> newChildren = new ArrayList<LogicalPlan>(nAry.children().size());
        boolean changed = false;
        for (LogicalPlan child : nAry.children()) {
            if (child instanceof LeafPlan) {
                LeafPlan source = (LeafPlan)child;
                ResolveUnmapped.assertSourceType(source);
                child = new Eval(source.source(), source, nullAliases);
                changed = true;
            }
            newChildren.add(child);
        }
        return changed ? (LogicalPlan)nAry.replaceChildren(newChildren) : nAry;
    }

    private static LogicalPlan evalUnresolvedUnary(UnaryPlan unaryAtopSource, List<Alias> nullAliases) {
        Eval eval;
        ResolveUnmapped.assertSourceType(unaryAtopSource.child());
        if (unaryAtopSource instanceof Eval && (eval = (Eval)unaryAtopSource).resolved()) {
            ArrayList<Alias> pre = new ArrayList<Alias>(nullAliases.size());
            ArrayList post = new ArrayList(nullAliases.size());
            Set<String> outputNames = eval.outputSet().names();
            Set<String> evalRefNames = eval.references().names();
            for (Alias a : nullAliases) {
                if (outputNames.contains(a.name())) continue;
                ArrayList<Alias> target = evalRefNames.contains(a.name()) ? pre : post;
                target.add(a);
            }
            if (pre.size() + post.size() == 0) {
                return eval;
            }
            return new Eval(eval.source(), eval.child(), CollectionUtils.combine(new Collection[]{pre, eval.fields(), post}));
        }
        return unaryAtopSource.replaceChild(new Eval(unaryAtopSource.source(), unaryAtopSource.child(), nullAliases));
    }

    private static void assertSourceType(LogicalPlan source) {
        LogicalPlan logicalPlan = source;
        Objects.requireNonNull(logicalPlan);
        LogicalPlan logicalPlan2 = logicalPlan;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EsRelation.class, Row.class, LocalRelation.class}, (Object)logicalPlan2, n)) {
            case 0: {
                EsRelation unused = (EsRelation)logicalPlan2;
                break;
            }
            case 1: {
                Row unused = (Row)logicalPlan2;
                break;
            }
            case 2: {
                LocalRelation unused = (LocalRelation)logicalPlan2;
                break;
            }
            default: {
                throw new EsqlIllegalArgumentException("unexpected source type [{}]", source);
            }
        }
    }

    private static List<Alias> nullAliases(List<UnresolvedAttribute> unresolved) {
        LinkedHashMap aliasesMap = new LinkedHashMap(unresolved.size());
        unresolved.forEach(u -> aliasesMap.computeIfAbsent(u.name(), k -> ResolveUnmapped.nullAlias(u)));
        return new ArrayList<Alias>(aliasesMap.values());
    }

    private static Alias nullAlias(Attribute attribute) {
        return new Alias(attribute.source(), attribute.name(), NULLIFIED);
    }

    private static List<UnresolvedAttribute> collectUnresolved(LogicalPlan plan) {
        ArrayList<UnresolvedAttribute> unresolved = new ArrayList<UnresolvedAttribute>();
        plan.forEachExpression(UnresolvedAttribute.class, ua -> {
            if (!(ua instanceof UnresolvedPattern || ua instanceof UnresolvedTimestamp)) {
                unresolved.add((UnresolvedAttribute)ua);
            }
        });
        return unresolved;
    }
}

