/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.expression.function.Functions;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.rule.Rule;

public class TimeSeriesGroupByAll
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan logicalPlan) {
        return logicalPlan.transformUp(node -> node instanceof TimeSeriesAggregate, this::rule);
    }

    public LogicalPlan rule(TimeSeriesAggregate aggregate) {
        Node lastTSAggFunction = null;
        Node lastNonTSAggFunction = null;
        ArrayList<NamedExpression> newAggregateFunctions = new ArrayList<NamedExpression>(aggregate.aggregates().size());
        for (NamedExpression namedExpression : aggregate.aggregates()) {
            Object alias;
            Expression expression;
            if (namedExpression instanceof Alias && (expression = ((Alias)(alias = (Alias)namedExpression)).child()) instanceof AggregateFunction) {
                AggregateFunction af = (AggregateFunction)expression;
                if (af instanceof TimeSeriesAggregateFunction) {
                    TimeSeriesAggregateFunction tsAgg = (TimeSeriesAggregateFunction)af;
                    newAggregateFunctions.add(new Alias(((Node)alias).source(), ((NamedExpression)alias).name(), new Values(tsAgg.source(), tsAgg)));
                    lastTSAggFunction = tsAgg;
                    continue;
                }
                newAggregateFunctions.add(namedExpression);
                lastNonTSAggFunction = af;
                continue;
            }
            newAggregateFunctions.add(namedExpression);
        }
        if (lastTSAggFunction == null) {
            return aggregate;
        }
        if (lastNonTSAggFunction != null) {
            throw new IllegalArgumentException("Cannot mix time-series aggregate [" + lastTSAggFunction.sourceText() + "] and regular aggregate [" + lastNonTSAggFunction.sourceText() + "] in the same TimeSeriesAggregate.");
        }
        FieldAttribute timeSeries = new FieldAttribute(aggregate.source(), null, null, "_timeseries", new EsField("_timeseries", DataType.KEYWORD, Map.of(), false, EsField.TimeSeriesFieldType.DIMENSION));
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(timeSeries);
        for (Expression grouping : aggregate.groupings()) {
            if (!Functions.isGrouping(Alias.unwrap(grouping))) {
                throw new IllegalArgumentException("Only grouping functions are supported (e.g. tbucket) when the time series aggregation function [" + lastTSAggFunction.sourceText() + "] is not wrapped with another aggregation function. Found [" + grouping.sourceText() + "].");
            }
            arrayList.add(grouping);
        }
        TimeSeriesAggregate newStats = new TimeSeriesAggregate(aggregate.source(), aggregate.child(), arrayList, newAggregateFunctions, null);
        return newStats.transformDown(EsRelation.class, r -> {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(r.output());
            attributes.add(timeSeries);
            return new EsRelation(r.source(), r.indexPattern(), r.indexMode(), r.originalIndices(), r.concreteIndices(), r.indexNameWithModes(), attributes);
        });
    }
}

