/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.action.RequestXContent;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plugin.EsqlQueryStatus;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;

public class EsqlQueryRequest
extends org.elasticsearch.xpack.core.esql.action.EsqlQueryRequest
implements CompositeIndicesRequest,
IndicesRequest.CrossProjectCandidate {
    public static TimeValue DEFAULT_KEEP_ALIVE = TimeValue.timeValueDays((long)5L);
    public static TimeValue DEFAULT_WAIT_FOR_COMPLETION = TimeValue.timeValueSeconds((long)1L);
    private boolean async;
    private String query;
    private boolean columnar;
    private boolean profile;
    private Boolean includeCCSMetadata;
    private Boolean includeExecutionMetadata;
    private ZoneId timeZone;
    private Locale locale;
    private QueryBuilder filter;
    private QueryPragmas pragmas = new QueryPragmas(Settings.EMPTY);
    private QueryParams params = new QueryParams();
    private TimeValue waitForCompletionTimeout = DEFAULT_WAIT_FOR_COMPLETION;
    private TimeValue keepAlive = DEFAULT_KEEP_ALIVE;
    private boolean keepOnCompletion;
    private boolean onSnapshotBuild = Build.current().isSnapshot();
    private boolean acceptedPragmaRisks = false;
    private Boolean allowPartialResults = null;
    private String projectRouting;
    private final Map<String, Map<String, Column>> tables = new TreeMap<String, Map<String, Column>>();

    public static EsqlQueryRequest syncEsqlQueryRequest(String query) {
        return new EsqlQueryRequest(false, query);
    }

    public static EsqlQueryRequest asyncEsqlQueryRequest(String query) {
        return new EsqlQueryRequest(true, query);
    }

    private EsqlQueryRequest(boolean async, String query) {
        this.async = async;
        this.query = query;
    }

    public EsqlQueryRequest() {
    }

    public EsqlQueryRequest(StreamInput in) throws IOException {
        super(in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText((String)this.query)) {
            validationException = ValidateActions.addValidationError((String)("[" + String.valueOf(RequestXContent.QUERY_FIELD) + "] is required"), validationException);
        }
        if (!this.onSnapshotBuild) {
            if (this.timeZone != null) {
                validationException = ValidateActions.addValidationError((String)("[" + String.valueOf(RequestXContent.TIME_ZONE_FIELD) + "] only allowed in snapshot builds"), (ActionRequestValidationException)validationException);
            }
            if (!this.pragmas.isEmpty() && !this.acceptedPragmaRisks) {
                validationException = ValidateActions.addValidationError((String)("[" + String.valueOf(RequestXContent.PRAGMA_FIELD) + "] only allowed in snapshot builds"), (ActionRequestValidationException)validationException);
            }
            if (!this.tables.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)("[" + String.valueOf(RequestXContent.TABLES_FIELD) + "] only allowed in snapshot builds"), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }

    public EsqlQueryRequest query(String query) {
        this.query = query;
        return this;
    }

    public String query() {
        return this.query;
    }

    public boolean async() {
        return this.async;
    }

    public EsqlQueryRequest columnar(boolean columnar) {
        this.columnar = columnar;
        return this;
    }

    public boolean columnar() {
        return this.columnar;
    }

    public EsqlQueryRequest profile(boolean profile) {
        this.profile = profile;
        return this;
    }

    public EsqlQueryRequest includeCCSMetadata(Boolean include) {
        this.includeCCSMetadata = include;
        return this;
    }

    public Boolean includeCCSMetadata() {
        return this.includeCCSMetadata;
    }

    public EsqlQueryRequest includeExecutionMetadata(Boolean include) {
        this.includeExecutionMetadata = include;
        return this;
    }

    public Boolean includeExecutionMetadata() {
        return this.includeExecutionMetadata;
    }

    public boolean profile() {
        return this.profile;
    }

    public void timeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public void locale(Locale locale) {
        this.locale = locale;
    }

    public Locale locale() {
        return this.locale;
    }

    public EsqlQueryRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public EsqlQueryRequest pragmas(QueryPragmas pragmas) {
        this.pragmas = pragmas;
        return this;
    }

    public QueryPragmas pragmas() {
        return this.pragmas;
    }

    public QueryParams params() {
        return this.params;
    }

    public void params(QueryParams params) {
        this.params = params;
    }

    public TimeValue waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public EsqlQueryRequest waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        this.waitForCompletionTimeout = waitForCompletionTimeout;
        return this;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public EsqlQueryRequest keepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean keepOnCompletion() {
        return this.keepOnCompletion;
    }

    public EsqlQueryRequest keepOnCompletion(boolean keepOnCompletion) {
        this.keepOnCompletion = keepOnCompletion;
        return this;
    }

    public void addTable(String name, Map<String, Column> columns) {
        Map<String, Column> prev;
        for (Column c : columns.values()) {
            if (!(c.values().blockFactory().breaker() instanceof NoopCircuitBreaker)) {
                throw new AssertionError((Object)"block tracking not supported on tables parameter");
            }
        }
        Iterator<Column> itr = columns.values().iterator();
        if (itr.hasNext()) {
            int firstSize = itr.next().values().getPositionCount();
            while (itr.hasNext()) {
                int size = itr.next().values().getPositionCount();
                if (size == firstSize) continue;
                throw new IllegalArgumentException("mismatched column lengths: was [" + size + "] but expected [" + firstSize + "]");
            }
        }
        if ((prev = this.tables.put(name, columns)) != null) {
            Releasables.close(prev.values());
            throw new IllegalArgumentException("duplicate table for [" + name + "]");
        }
    }

    public Map<String, Map<String, Column>> tables() {
        return this.tables;
    }

    public Boolean allowPartialResults() {
        return this.allowPartialResults;
    }

    public EsqlQueryRequest allowPartialResults(boolean allowPartialResults) {
        this.allowPartialResults = allowPartialResults;
        return this;
    }

    public Task createTask(TaskId taskId, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        EsqlQueryStatus status = new EsqlQueryStatus(new AsyncExecutionId(UUIDs.randomBase64UUID(), taskId));
        return new EsqlQueryRequestTask(this.query, taskId.getId(), type, action, parentTaskId, headers, status);
    }

    void onSnapshotBuild(boolean onSnapshotBuild) {
        this.onSnapshotBuild = onSnapshotBuild;
    }

    void acceptedPragmaRisks(boolean accepted) {
        this.acceptedPragmaRisks = accepted;
    }

    public EsqlQueryRequest projectRouting(String projectRouting) {
        this.projectRouting = projectRouting;
        return this;
    }

    public String projectRouting() {
        return this.projectRouting;
    }

    public boolean allowsCrossProject() {
        return true;
    }

    private static class EsqlQueryRequestTask
    extends CancellableTask {
        private final Task.Status status;

        EsqlQueryRequestTask(String query, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, EsqlQueryStatus status) {
            super(id, type, action, query, parentTaskId, headers);
            this.status = status;
        }

        public Task.Status getStatus() {
            return this.status;
        }
    }
}

