/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.section.PrerequisiteSection;
import org.elasticsearch.test.rest.yaml.section.VersionRange;

public class Prerequisites {
    public static final Predicate<ClientYamlTestExecutionContext> TRUE = context -> true;
    public static final Predicate<ClientYamlTestExecutionContext> FALSE = context -> false;

    private Prerequisites() {
    }

    static Predicate<ClientYamlTestExecutionContext> skipOnVersionRange(String versionRange) {
        List<Predicate<Set<String>>> versionRangePredicates = VersionRange.parseVersionRanges(versionRange);
        assert (!versionRangePredicates.isEmpty());
        return context -> versionRangePredicates.stream().anyMatch(range -> range.test(context.nodesVersions()));
    }

    static Predicate<ClientYamlTestExecutionContext> skipOnOsList(List<String> operatingSystems) {
        return context -> operatingSystems.stream().anyMatch(osName -> osName.equals(context.os()));
    }

    static Predicate<ClientYamlTestExecutionContext> hasXPack() {
        return context -> ESRestTestCase.hasXPack();
    }

    static Predicate<ClientYamlTestExecutionContext> requireClusterFeatures(Set<String> clusterFeatures) {
        return context -> clusterFeatures.stream().allMatch(f -> context.clusterHasFeature((String)f, false));
    }

    static Predicate<ClientYamlTestExecutionContext> skipOnClusterFeatures(Set<String> clusterFeatures) {
        return context -> clusterFeatures.stream().anyMatch(f -> context.clusterHasFeature((String)f, true));
    }

    static Predicate<ClientYamlTestExecutionContext> skipOnKnownIssue(List<PrerequisiteSection.KnownIssue> knownIssues) {
        return context -> knownIssues.stream().anyMatch(i -> context.clusterHasFeature(i.clusterFeature(), true) && !context.clusterHasFeature(i.fixedBy(), false));
    }

    static CapabilitiesPredicate requireCapabilities(List<PrerequisiteSection.CapabilitiesCheck> checks) {
        return context -> checks.stream().allMatch(check -> Prerequisites.checkCapabilities(context, check, false).orElse(false));
    }

    static CapabilitiesPredicate skipCapabilities(List<PrerequisiteSection.CapabilitiesCheck> checks) {
        return context -> checks.stream().anyMatch(check -> Prerequisites.checkCapabilities(context, check, true).orElse(true));
    }

    private static Optional<Boolean> checkCapabilities(ClientYamlTestExecutionContext context, PrerequisiteSection.CapabilitiesCheck check, boolean any) {
        Optional<Boolean> b = context.clusterHasCapabilities(check.method(), check.path(), check.parameters(), check.capabilities(), any);
        return b;
    }

    static interface CapabilitiesPredicate
    extends Predicate<ClientYamlTestExecutionContext> {
    }
}

