/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.PrerequisiteSection;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public class ClientYamlTestSection
implements Comparable<ClientYamlTestSection> {
    private final XContentLocation location;
    private final String name;
    private final PrerequisiteSection prerequisiteSection;
    private final List<ExecutableSection> executableSections;

    public static ClientYamlTestSection parse(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        XContentLocation sectionLocation = parser.getTokenLocation();
        String sectionName = parser.currentName();
        ArrayList<ExecutableSection> executableSections = new ArrayList<ExecutableSection>();
        try {
            parser.nextToken();
            PrerequisiteSection prerequisiteSection = PrerequisiteSection.parseIfNext(parser);
            while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
                ParserUtils.advanceToFieldName(parser);
                executableSections.add(ExecutableSection.parse(parser));
            }
            if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new IllegalArgumentException("malformed section [" + sectionName + "] expected [" + String.valueOf(XContentParser.Token.END_OBJECT) + "] but was [" + String.valueOf(parser.currentToken()) + "]");
            }
            parser.nextToken();
            return new ClientYamlTestSection(sectionLocation, sectionName, prerequisiteSection, executableSections);
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), "Error parsing test named [" + sectionName + "]", (Throwable)e, new Object[0]);
        }
    }

    public ClientYamlTestSection(XContentLocation location, String name, PrerequisiteSection prerequisiteSection, List<ExecutableSection> executableSections) {
        this.location = location;
        this.name = name;
        this.prerequisiteSection = Objects.requireNonNull(prerequisiteSection, "skip section cannot be null");
        this.executableSections = Collections.unmodifiableList(executableSections);
    }

    public XContentLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public PrerequisiteSection getPrerequisiteSection() {
        return this.prerequisiteSection;
    }

    public List<ExecutableSection> getExecutableSections() {
        return this.executableSections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientYamlTestSection that = (ClientYamlTestSection)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public int compareTo(ClientYamlTestSection o) {
        return this.name.compareTo(o.getName());
    }
}

