/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.security.action.apikey.CertificateIdentity;
import org.elasticsearch.xpack.core.security.action.apikey.CreateCrossClusterApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.CreateCrossClusterApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CrossClusterApiKeyRoleDescriptorBuilder;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestCreateCrossClusterApiKeyAction
extends ApiKeyBaseRestHandler {
    static final ConstructingObjectParser<CreateCrossClusterApiKeyRequest, Void> PARSER = new ConstructingObjectParser("cross_cluster_api_key_request", false, (args, v) -> new CreateCrossClusterApiKeyRequest((String)args[0], (CrossClusterApiKeyRoleDescriptorBuilder)args[1], TimeValue.parseTimeValue((String)((String)args[2]), null, (String)"expiration"), (Map)args[3], (CertificateIdentity)args[4]));

    public RestCreateCrossClusterApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/cross_cluster/api_key"));
    }

    public String getName() {
        return "xpack_security_create_cross_cluster_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateCrossClusterApiKeyRequest createCrossClusterApiKeyRequest = (CreateCrossClusterApiKeyRequest)PARSER.parse(request.contentParser(), null);
        createCrossClusterApiKeyRequest.setRefreshPolicy(ApiKeyService.defaultCreateDocRefreshPolicy(this.settings));
        return channel -> client.execute((ActionType)CreateCrossClusterApiKeyAction.INSTANCE, (ActionRequest)createCrossClusterApiKeyRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        if (Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.checkWithoutTracking(this.licenseState)) {
            return null;
        }
        return LicenseUtils.newComplianceException((String)Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.getName());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)CrossClusterApiKeyRoleDescriptorBuilder.PARSER, new ParseField("access", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new CertificateIdentity(p.text()), new ParseField("certificate_identity", new String[0]), ObjectParser.ValueType.STRING);
    }
}

