/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.fixture;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HttpHeaderParser
extends Enum<HttpHeaderParser> {
    private static final Pattern RANGE_HEADER_PATTERN;
    private static final Pattern CONTENT_RANGE_HEADER_PATTERN;
    private static final /* synthetic */ HttpHeaderParser[] $VALUES;

    public static HttpHeaderParser[] values() {
        return (HttpHeaderParser[])$VALUES.clone();
    }

    public static HttpHeaderParser valueOf(String name) {
        return Enum.valueOf(HttpHeaderParser.class, name);
    }

    public static Range parseRangeHeader(String rangeHeaderValue) {
        Matcher matcher = RANGE_HEADER_PATTERN.matcher(rangeHeaderValue);
        if (matcher.matches()) {
            try {
                return new Range(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static ContentRange parseContentRangeHeader(String contentRangeHeaderValue) {
        Matcher matcher = CONTENT_RANGE_HEADER_PATTERN.matcher(contentRangeHeaderValue);
        if (matcher.matches()) {
            try {
                if (matcher.groupCount() == 3) {
                    Long start = HttpHeaderParser.parseOptionalLongValue(matcher.group(1));
                    Long end = HttpHeaderParser.parseOptionalLongValue(matcher.group(2));
                    Long size = HttpHeaderParser.parseOptionalLongValue(matcher.group(3));
                    return new ContentRange(start, end, size);
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static Long parseOptionalLongValue(String value) {
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    private static /* synthetic */ HttpHeaderParser[] $values() {
        return new HttpHeaderParser[0];
    }

    static {
        $VALUES = HttpHeaderParser.$values();
        RANGE_HEADER_PATTERN = Pattern.compile("bytes=([0-9]+)-([0-9]+)");
        CONTENT_RANGE_HEADER_PATTERN = Pattern.compile("bytes (?:(\\d+)-(\\d+)|\\*)/(?:(\\d+)|\\*)");
    }

    public record Range(long start, long end) {
        public String headerString() {
            return "bytes=" + this.start + "-" + this.end;
        }
    }

    public record ContentRange(Long start, Long end, Long size) {
        public ContentRange {
            assert (start == null == (end == null)) : "Must have either start and end or neither";
        }

        public boolean hasRange() {
            return this.start != null && this.end != null;
        }

        public boolean hasSize() {
            return this.size != null;
        }

        public String headerString() {
            String rangeString = this.hasRange() ? this.start + "-" + this.end : "*";
            String sizeString = this.hasSize() ? String.valueOf(this.size) : "*";
            return "bytes " + rangeString + "/" + sizeString;
        }
    }
}

