/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.VersionUtils;

public class TransportVersionUtils {
    private static final NavigableSet<TransportVersion> RELEASED_VERSIONS = Collections.unmodifiableNavigableSet(new TreeSet(TransportVersion.getAllVersions()));
    private static final NavigableSet<TransportVersion> NON_PATCH_VERSIONS = Collections.unmodifiableNavigableSet(TransportVersion.getAllVersions().stream().filter(Predicate.not(TransportVersionUtils::isPatchVersion)).collect(Collectors.toCollection(TreeSet::new)));

    public static NavigableSet<TransportVersion> allReleasedVersions() {
        return RELEASED_VERSIONS;
    }

    public static TransportVersion getFirstVersion() {
        return (TransportVersion)TransportVersionUtils.allReleasedVersions().getFirst();
    }

    public static TransportVersion randomVersion() {
        return VersionUtils.randomFrom(LuceneTestCase.random(), TransportVersionUtils.allReleasedVersions());
    }

    public static TransportVersion randomVersion(Set<TransportVersion> ignore) {
        return (TransportVersion)ESTestCase.randomFrom(TransportVersionUtils.allReleasedVersions().stream().filter(v -> !ignore.contains(v)).collect(Collectors.toList()));
    }

    public static TransportVersion randomVersion(Random random) {
        return (TransportVersion)RandomPicks.randomFrom((Random)random, TransportVersionUtils.allReleasedVersions());
    }

    public static TransportVersion randomVersionSupporting(Random random, TransportVersion minVersion) {
        return (TransportVersion)RandomPicks.randomFrom((Random)random, RELEASED_VERSIONS.stream().filter(v -> v.supports(minVersion)).toList());
    }

    public static TransportVersion randomVersionNotSupporting(Random random, TransportVersion version) {
        return (TransportVersion)RandomPicks.randomFrom((Random)random, RELEASED_VERSIONS.stream().filter(v -> !v.supports(version)).toList());
    }

    public static TransportVersion getPreviousVersion(TransportVersion version) {
        return TransportVersionUtils.getPreviousVersion(version, false);
    }

    public static TransportVersion getPreviousVersion(TransportVersion version, boolean createIfNecessary) {
        TransportVersion lower = (TransportVersionUtils.isPatchVersion(version) ? RELEASED_VERSIONS : NON_PATCH_VERSIONS).lower(version);
        if (lower == null) {
            if (createIfNecessary) {
                return new TransportVersion(version.id() - 1);
            }
            throw new IllegalArgumentException("couldn't find any released versions before [" + String.valueOf(version) + "]");
        }
        return lower;
    }

    public static TransportVersion getNextVersion(TransportVersion version) {
        return TransportVersionUtils.getNextVersion(version, false);
    }

    public static TransportVersion getNextVersion(TransportVersion version, boolean createIfNecessary) {
        TransportVersion higher = (TransportVersionUtils.isPatchVersion(version) ? RELEASED_VERSIONS : NON_PATCH_VERSIONS).higher(version);
        if (higher != null && TransportVersionUtils.isPatchVersion(version) && !TransportVersionUtils.isPatchVersion(higher)) {
            throw new IllegalStateException("couldn't determine next version as version [" + String.valueOf(version) + "] is  patch, and is the newest patch");
        }
        if (higher == null) {
            if (createIfNecessary) {
                return new TransportVersion(version.id() + 1);
            }
            throw new IllegalArgumentException("couldn't find any released versions after [" + String.valueOf(version) + "]");
        }
        return higher;
    }

    public static TransportVersion randomCompatibleVersion(Random random) {
        return TransportVersionUtils.randomCompatibleVersion(random, true);
    }

    public static TransportVersion randomCompatibleVersion(Random random, boolean includePatches) {
        return (TransportVersion)RandomPicks.randomFrom((Random)random, (includePatches ? RELEASED_VERSIONS : NON_PATCH_VERSIONS).stream().filter(TransportVersion::isCompatible).toList());
    }

    private static boolean isPatchVersion(TransportVersion version) {
        return version.id() % 100 != 0;
    }
}

