/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.rerank;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matchers;

@ESIntegTestCase.ClusterScope(minNumDataNodes=3)
public abstract class AbstractRerankerIT
extends ESIntegTestCase {
    protected abstract RankBuilder getRankBuilder(int var1, String var2);

    protected abstract RankBuilder getThrowingRankBuilder(int var1, String var2, ThrowingRankBuilderType var3);

    protected abstract Collection<Class<? extends Plugin>> pluginsNeeded();

    protected boolean shouldCheckScores() {
        return true;
    }

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return this.pluginsNeeded();
    }

    public void testRerankerNoExceptions() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getRankBuilder(10, "rankFeatureField")).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10), response -> {
            ElasticsearchAssertions.assertHitCount(response, 5L);
            int rank = 1;
            for (SearchHit searchHit : response.getHits().getHits()) {
                AbstractRerankerIT.assertThat(searchHit, ElasticsearchAssertions.hasId(String.valueOf(5 - (rank - 1))));
                AbstractRerankerIT.assertThat(searchHit, ElasticsearchAssertions.hasRank(rank));
                AbstractRerankerIT.assertNotNull(searchHit.getFields().get("searchField"));
                if (this.shouldCheckScores()) {
                    AbstractRerankerIT.assertEquals((float)(0.5f - (float)(rank - 1) * 0.1f), (float)searchHit.getScore(), (float)1.0E-5f);
                }
                ++rank;
            }
        });
        this.assertNoOpenContext("test_index");
    }

    public void testRerankerPagination() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        ElasticsearchAssertions.assertResponse(AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getRankBuilder(10, "rankFeatureField")).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(2).setFrom(2), response -> {
            ElasticsearchAssertions.assertHitCount(response, 5L);
            int rank = 3;
            for (SearchHit searchHit : response.getHits().getHits()) {
                AbstractRerankerIT.assertThat(searchHit, ElasticsearchAssertions.hasId(String.valueOf(5 - (rank - 1))));
                AbstractRerankerIT.assertThat(searchHit, ElasticsearchAssertions.hasRank(rank));
                AbstractRerankerIT.assertNotNull(searchHit.getFields().get("searchField"));
                if (this.shouldCheckScores()) {
                    AbstractRerankerIT.assertEquals((float)(0.5f - (float)(rank - 1) * 0.1f), (float)searchHit.getScore(), (float)1.0E-5f);
                }
                ++rank;
            }
        });
        this.assertNoOpenContext("test_index");
    }

    public void testRerankerPaginationOutsideOfBounds() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getRankBuilder(10, "rankFeatureField")).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(2).setFrom(10), response -> {
            ElasticsearchAssertions.assertHitCount(response, 5L);
            AbstractRerankerIT.assertThat(response.getHits().getHits(), Matchers.emptyArray());
        });
        this.assertNoOpenContext("test_index");
    }

    public void testNotAllShardsArePresentInFetchPhase() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index", Settings.builder().put("index.number_of_shards", 10).build());
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}).setRouting("A"), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}).setRouting("B"), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}).setRouting("C"), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}).setRouting("C"), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}).setRouting("C"));
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(0.1f)).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(0.3f)).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(0.3f)).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(0.3f))).setRankBuilder(this.getRankBuilder(10, "rankFeatureField")).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(2), response -> {
            ElasticsearchAssertions.assertHitCount(response, 4L);
            AbstractRerankerIT.assertThat(response.getHits().getHits(), Matchers.arrayWithSize((int)2));
            int rank = 1;
            for (SearchHit searchHit : response.getHits().getHits()) {
                AbstractRerankerIT.assertThat(searchHit, ElasticsearchAssertions.hasId(String.valueOf(5 - (rank - 1))));
                AbstractRerankerIT.assertThat(searchHit, ElasticsearchAssertions.hasRank(rank));
                AbstractRerankerIT.assertNotNull(searchHit.getFields().get("searchField"));
                if (this.shouldCheckScores()) {
                    AbstractRerankerIT.assertEquals((float)(0.5f - (float)(rank - 1) * 0.1f), (float)searchHit.getScore(), (float)1.0E-5f);
                }
                ++rank;
            }
        });
        this.assertNoOpenContext("test_index");
    }

    public void testRerankerNoMatchingDocs() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"F")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getRankBuilder(10, "rankFeatureField")).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10), response -> ElasticsearchAssertions.assertHitCount(response, 0L));
        this.assertNoOpenContext("test_index");
    }

    public void testQueryPhaseShardThrowingAllShardsFail() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        AbstractRerankerIT.expectThrows(SearchPhaseExecutionException.class, () -> {
            SearchResponse response = (SearchResponse)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getThrowingRankBuilder(10, "rankFeatureField", ThrowingRankBuilderType.THROWING_QUERY_PHASE_SHARD_CONTEXT)).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10).get();
            response.decRef();
        });
        this.assertNoOpenContext("test_index");
    }

    public void testQueryPhaseCoordinatorThrowingAllShardsFail() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        AbstractRerankerIT.expectThrows(SearchPhaseExecutionException.class, () -> {
            SearchResponse response = (SearchResponse)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getThrowingRankBuilder(10, "rankFeatureField", ThrowingRankBuilderType.THROWING_QUERY_PHASE_COORDINATOR_CONTEXT)).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10).get();
            response.decRef();
        });
        this.assertNoOpenContext("test_index");
    }

    public void testRankFeaturePhaseShardThrowingPartialFailures() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index", Settings.builder().put("index.number_of_shards", 10).build());
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        ElasticsearchAssertions.assertResponse(AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getThrowingRankBuilder(10, "rankFeatureField", ThrowingRankBuilderType.THROWING_RANK_FEATURE_PHASE_SHARD_CONTEXT)).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10), response -> {
            AbstractRerankerIT.assertThat(response.getFailedShards(), Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            AbstractRerankerIT.assertTrue((boolean)Arrays.stream(response.getShardFailures()).allMatch(failure -> failure.getCause().getMessage().contains("rfs - simulated failure")));
            ElasticsearchAssertions.assertHitCount(response, 5L);
            AbstractRerankerIT.assertThat(response.getHits().getHits(), Matchers.emptyArray());
        });
        this.assertNoOpenContext("test_index");
    }

    public void testRankFeaturePhaseShardThrowingAllShardsFail() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index", Settings.builder().put("index.number_of_shards", 1).build());
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        AbstractRerankerIT.expectThrows(SearchPhaseExecutionException.class, () -> {
            SearchResponse response = (SearchResponse)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getThrowingRankBuilder(10, "rankFeatureField", ThrowingRankBuilderType.THROWING_RANK_FEATURE_PHASE_SHARD_CONTEXT)).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10).get();
            response.decRef();
        });
        this.assertNoOpenContext("test_index");
    }

    public void testRankFeaturePhaseCoordinatorThrowingAllShardsFail() throws Exception {
        String indexName = "test_index";
        String rankFeatureField = "rankFeatureField";
        String searchField = "searchField";
        int rankWindowSize = 10;
        this.createIndex("test_index");
        this.indexRandom(true, AbstractRerankerIT.prepareIndex("test_index").setId("1").setSource(new Object[]{"rankFeatureField", 0.1, "searchField", "A"}), AbstractRerankerIT.prepareIndex("test_index").setId("2").setSource(new Object[]{"rankFeatureField", 0.2, "searchField", "B"}), AbstractRerankerIT.prepareIndex("test_index").setId("3").setSource(new Object[]{"rankFeatureField", 0.3, "searchField", "C"}), AbstractRerankerIT.prepareIndex("test_index").setId("4").setSource(new Object[]{"rankFeatureField", 0.4, "searchField", "D"}), AbstractRerankerIT.prepareIndex("test_index").setId("5").setSource(new Object[]{"rankFeatureField", 0.5, "searchField", "E"}));
        AbstractRerankerIT.expectThrows(SearchPhaseExecutionException.class, () -> {
            SearchResponse response = (SearchResponse)AbstractRerankerIT.prepareSearch(new String[0]).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"A")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"B")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"C")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"D")).boost(AbstractRerankerIT.randomFloat())).should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.matchQuery((String)"searchField", (Object)"E")).boost(AbstractRerankerIT.randomFloat()))).setRankBuilder(this.getThrowingRankBuilder(10, "rankFeatureField", ThrowingRankBuilderType.THROWING_RANK_FEATURE_PHASE_COORDINATOR_CONTEXT)).addFetchField("searchField").setTrackTotalHits(true).setAllowPartialSearchResults(true).setSize(10).get();
            response.decRef();
        });
        this.assertNoOpenContext("test_index");
    }

    protected void assertNoOpenContext(String indexName) throws Exception {
        AbstractRerankerIT.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractRerankerIT.assertThat(((IndicesStatsResponse)AbstractRerankerIT.indicesAdmin().prepareStats(new String[]{indexName}).get()).getTotal().getSearch().getOpenContexts(), Matchers.equalTo((Object)0L))), 1L, TimeUnit.SECONDS);
    }

    public static enum ThrowingRankBuilderType {
        THROWING_QUERY_PHASE_SHARD_CONTEXT,
        THROWING_QUERY_PHASE_COORDINATOR_CONTEXT,
        THROWING_RANK_FEATURE_PHASE_SHARD_CONTEXT,
        THROWING_RANK_FEATURE_PHASE_COORDINATOR_CONTEXT;

    }
}

