/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;

public interface SpatialQueryBuilders<T extends AbstractGeometryQueryBuilder<T>> {
    public static final Geo GEO = new Geo();

    public AbstractGeometryQueryBuilder<T> shapeQuery(String var1, Geometry var2);

    public AbstractGeometryQueryBuilder<T> shapeQuery(String var1, String var2);

    public AbstractGeometryQueryBuilder<T> intersectionQuery(String var1, Geometry var2) throws IOException;

    public AbstractGeometryQueryBuilder<T> intersectionQuery(String var1, String var2);

    public AbstractGeometryQueryBuilder<T> withinQuery(String var1, Geometry var2) throws IOException;

    public AbstractGeometryQueryBuilder<T> withinQuery(String var1, String var2);

    public AbstractGeometryQueryBuilder<T> disjointQuery(String var1, Geometry var2) throws IOException;

    public AbstractGeometryQueryBuilder<T> disjointQuery(String var1, String var2);

    public static final class Geo
    implements SpatialQueryBuilders<GeoShapeQueryBuilder> {
        public GeoDistanceQueryBuilder distanceQuery(String name) {
            return new GeoDistanceQueryBuilder(name);
        }

        public GeoBoundingBoxQueryBuilder boundingBoxQuery(String name) {
            return new GeoBoundingBoxQueryBuilder(name);
        }

        @Deprecated
        public GeoPolygonQueryBuilder polygonQuery(String name, List<GeoPoint> points) {
            return new GeoPolygonQueryBuilder(name, points);
        }

        public GeoShapeQueryBuilder shapeQuery(String name, Geometry shape) {
            return new GeoShapeQueryBuilder(name, shape);
        }

        public GeoShapeQueryBuilder shapeQuery(String name, String indexedShapeId) {
            return new GeoShapeQueryBuilder(name, indexedShapeId);
        }

        public GeoShapeQueryBuilder intersectionQuery(String name, Geometry shape) throws IOException {
            GeoShapeQueryBuilder builder = this.shapeQuery(name, shape);
            builder.relation(ShapeRelation.INTERSECTS);
            return builder;
        }

        public GeoShapeQueryBuilder intersectionQuery(String name, String indexedShapeId) {
            GeoShapeQueryBuilder builder = this.shapeQuery(name, indexedShapeId);
            builder.relation(ShapeRelation.INTERSECTS);
            return builder;
        }

        public GeoShapeQueryBuilder withinQuery(String name, Geometry shape) throws IOException {
            GeoShapeQueryBuilder builder = this.shapeQuery(name, shape);
            builder.relation(ShapeRelation.WITHIN);
            return builder;
        }

        public GeoShapeQueryBuilder withinQuery(String name, String indexedShapeId) {
            GeoShapeQueryBuilder builder = this.shapeQuery(name, indexedShapeId);
            builder.relation(ShapeRelation.WITHIN);
            return builder;
        }

        public GeoShapeQueryBuilder disjointQuery(String name, Geometry shape) throws IOException {
            GeoShapeQueryBuilder builder = this.shapeQuery(name, shape);
            builder.relation(ShapeRelation.DISJOINT);
            return builder;
        }

        public GeoShapeQueryBuilder disjointQuery(String name, String indexedShapeId) {
            GeoShapeQueryBuilder builder = this.shapeQuery(name, indexedShapeId);
            builder.relation(ShapeRelation.DISJOINT);
            return builder;
        }
    }
}

