/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.elasticsearch.test.TransportVersionUtils;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matchers;

public abstract class AbstractSignificanceHeuristicTestCase
extends ESTestCase {
    protected abstract SignificanceHeuristic getHeuristic();

    protected TransportVersion randomVersion() {
        return TransportVersionUtils.randomVersion(AbstractSignificanceHeuristicTestCase.random());
    }

    public void testStreamResponse() throws Exception {
        TransportVersion version = this.randomVersion();
        InternalMappedSignificantTerms<?, ?> sigTerms = this.getRandomSignificantTerms(this.getHeuristic());
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        OutputStreamStreamOutput out = new OutputStreamStreamOutput((OutputStream)outBuffer);
        out.setTransportVersion(version);
        out.writeNamedWriteable(sigTerms);
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(outBuffer.toByteArray());
        InputStreamStreamInput in = new InputStreamStreamInput((InputStream)inBuffer);
        in = new NamedWriteableAwareStreamInput((StreamInput)in, this.writableRegistry());
        in.setTransportVersion(version);
        InternalMappedSignificantTerms read = (InternalMappedSignificantTerms)in.readNamedWriteable(InternalAggregation.class);
        AbstractSignificanceHeuristicTestCase.assertEquals((Object)sigTerms.getSignificanceHeuristic(), (Object)read.getSignificanceHeuristic());
        AbstractSignificanceHeuristicTestCase.assertThat(read.getSubsetSize(), Matchers.equalTo((Object)10L));
        AbstractSignificanceHeuristicTestCase.assertThat(read.getSupersetSize(), Matchers.equalTo((Object)20L));
        SignificantTerms.Bucket originalBucket = (SignificantTerms.Bucket)sigTerms.getBuckets().get(0);
        SignificantTerms.Bucket streamedBucket = (SignificantTerms.Bucket)read.getBuckets().get(0);
        AbstractSignificanceHeuristicTestCase.assertThat(originalBucket.getKeyAsString(), Matchers.equalTo((Object)streamedBucket.getKeyAsString()));
        AbstractSignificanceHeuristicTestCase.assertThat(originalBucket.getSupersetDf(), Matchers.equalTo((Object)streamedBucket.getSupersetDf()));
        AbstractSignificanceHeuristicTestCase.assertThat(originalBucket.getSubsetDf(), Matchers.equalTo((Object)streamedBucket.getSubsetDf()));
    }

    InternalMappedSignificantTerms<?, ?> getRandomSignificantTerms(SignificanceHeuristic heuristic) {
        if (AbstractSignificanceHeuristicTestCase.randomBoolean()) {
            SignificantLongTerms.Bucket bucket = new SignificantLongTerms.Bucket(1L, 3L, 123L, InternalAggregations.EMPTY, DocValueFormat.RAW, AbstractSignificanceHeuristicTestCase.randomDoubleBetween(0.0, 100.0, true));
            return new SignificantLongTerms("some_name", 1, 1L, null, DocValueFormat.RAW, 10L, 20L, heuristic, Collections.singletonList(bucket));
        }
        SignificantStringTerms.Bucket bucket = new SignificantStringTerms.Bucket(new BytesRef((CharSequence)"someterm"), 1L, 3L, InternalAggregations.EMPTY, DocValueFormat.RAW, AbstractSignificanceHeuristicTestCase.randomDoubleBetween(0.0, 100.0, true));
        return new SignificantStringTerms("some_name", 1, 1L, null, DocValueFormat.RAW, 10L, 20L, heuristic, Collections.singletonList(bucket));
    }

    public void testReduce() {
        List<InternalAggregation> aggs = this.createInternalAggregations();
        AggregationReduceContext context = InternalAggregationTestCase.emptyReduceContextBuilder().forFinalReduction();
        SignificantTerms reducedAgg = (SignificantTerms)InternalAggregationTestCase.reduce(aggs, context);
        AbstractSignificanceHeuristicTestCase.assertThat(reducedAgg.getSubsetSize(), Matchers.equalTo((Object)16L));
        AbstractSignificanceHeuristicTestCase.assertThat(reducedAgg.getSupersetSize(), Matchers.equalTo((Object)30L));
        AbstractSignificanceHeuristicTestCase.assertThat(reducedAgg.getBuckets().size(), Matchers.equalTo((Object)2));
        AbstractSignificanceHeuristicTestCase.assertThat(((SignificantTerms.Bucket)reducedAgg.getBuckets().get(0)).getSubsetDf(), Matchers.equalTo((Object)8L));
        AbstractSignificanceHeuristicTestCase.assertThat(((SignificantTerms.Bucket)reducedAgg.getBuckets().get(0)).getSupersetDf(), Matchers.equalTo((Object)10L));
        AbstractSignificanceHeuristicTestCase.assertThat(((SignificantTerms.Bucket)reducedAgg.getBuckets().get(1)).getSubsetDf(), Matchers.equalTo((Object)8L));
        AbstractSignificanceHeuristicTestCase.assertThat(((SignificantTerms.Bucket)reducedAgg.getBuckets().get(1)).getSupersetDf(), Matchers.equalTo((Object)10L));
    }

    public void testBasicScoreProperties() {
        this.testBasicScoreProperties(this.getHeuristic(), true);
    }

    protected void testBasicScoreProperties(SignificanceHeuristic heuristic, boolean testZeroScore) {
        AbstractSignificanceHeuristicTestCase.assertThat(heuristic.getScore(1L, 1L, 1L, 3L), Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        AbstractSignificanceHeuristicTestCase.assertThat(heuristic.getScore(1L, 1L, 2L, 3L), Matchers.lessThan((Comparable)Double.valueOf(heuristic.getScore(1L, 1L, 1L, 3L))));
        AbstractSignificanceHeuristicTestCase.assertThat(heuristic.getScore(1L, 1L, 3L, 4L), Matchers.lessThan((Comparable)Double.valueOf(heuristic.getScore(1L, 1L, 2L, 4L))));
        if (testZeroScore) {
            AbstractSignificanceHeuristicTestCase.assertThat(heuristic.getScore(0L, 1L, 2L, 3L), Matchers.equalTo((Object)0.0));
        }
        double score = 0.0;
        try {
            long a = AbstractSignificanceHeuristicTestCase.randomLong();
            long b = AbstractSignificanceHeuristicTestCase.randomLong();
            long c = AbstractSignificanceHeuristicTestCase.randomLong();
            long d = AbstractSignificanceHeuristicTestCase.randomLong();
            score = heuristic.getScore(a, b, c, d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AbstractSignificanceHeuristicTestCase.assertThat(score, Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(0.0)));
    }

    public abstract void testAssertions();

    public void testParseFromString() throws IOException {
        SignificanceHeuristic significanceHeuristic = this.getHeuristic();
        try (XContentBuilder builder = JsonXContent.contentBuilder();){
            builder.startObject().field("field", "text").field("min_doc_count", "200");
            significanceHeuristic.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            try (XContentParser stParser = this.createParser(builder);){
                SignificanceHeuristic parsedHeuristic = AbstractSignificanceHeuristicTestCase.parseSignificanceHeuristic(stParser);
                AbstractSignificanceHeuristicTestCase.assertThat(significanceHeuristic, Matchers.equalTo((Object)parsedHeuristic));
            }
        }
    }

    public void testParseFromAggBuilder() throws IOException {
        SignificanceHeuristic parsedHeuristic;
        SignificanceHeuristic significanceHeuristic = this.getHeuristic();
        SignificantTermsAggregationBuilder stBuilder = AggregationBuilders.significantTerms((String)"testagg");
        ((SignificantTermsAggregationBuilder)stBuilder.significanceHeuristic(significanceHeuristic).field("text")).minDocCount(200L);
        XContentBuilder stXContentBuilder = XContentFactory.jsonBuilder();
        stBuilder.internalXContent(stXContentBuilder, null);
        try (XContentParser stParser = this.createParser(JsonXContent.jsonXContent, Strings.toString((XContentBuilder)stXContentBuilder));){
            parsedHeuristic = AbstractSignificanceHeuristicTestCase.parseSignificanceHeuristic(stParser);
        }
        AbstractSignificanceHeuristicTestCase.assertThat(significanceHeuristic, Matchers.equalTo((Object)parsedHeuristic));
    }

    public void testParseFailure() throws IOException {
        SignificanceHeuristic significanceHeuristic = this.getHeuristic();
        try (XContentBuilder builder = JsonXContent.contentBuilder();){
            builder.startObject().field("field", "text").startObject(significanceHeuristic.getWriteableName()).field("unknown_field", false).endObject().field("min_doc_count", "200").endObject();
            try (XContentParser stParser = this.createParser(builder);){
                try {
                    AbstractSignificanceHeuristicTestCase.parseSignificanceHeuristic(stParser);
                    AbstractSignificanceHeuristicTestCase.fail((String)"parsing the heurstic should have failed");
                }
                catch (XContentParseException e) {
                    AbstractSignificanceHeuristicTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"unknown field [unknown_field]"));
                }
            }
        }
    }

    private List<InternalAggregation> createInternalAggregations() {
        SignificanceHeuristic significanceHeuristic = this.getHeuristic();
        TestAggFactory factory = AbstractSignificanceHeuristicTestCase.randomBoolean() ? new StringTestAggFactory(this) : new LongTestAggFactory(this);
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        aggs.add((InternalAggregation)factory.createAggregation(significanceHeuristic, 4L, 10L, 1, (f, i) -> f.createBucket(4L, 5L, 0L)));
        aggs.add((InternalAggregation)factory.createAggregation(significanceHeuristic, 4L, 10L, 1, (f, i) -> f.createBucket(4L, 5L, 1L)));
        aggs.add((InternalAggregation)factory.createAggregation(significanceHeuristic, 8L, 10L, 2, (f, i) -> f.createBucket(4L, 5L, i.intValue())));
        return aggs;
    }

    private static SignificanceHeuristic parseSignificanceHeuristic(XContentParser stParser) throws IOException {
        stParser.nextToken();
        SignificantTermsAggregationBuilder aggregatorFactory = SignificantTermsAggregationBuilder.parse((String)"testagg", (XContentParser)stParser);
        stParser.nextToken();
        AbstractSignificanceHeuristicTestCase.assertThat(aggregatorFactory.getBucketCountThresholds().getMinDocCount(), Matchers.equalTo((Object)200L));
        AbstractSignificanceHeuristicTestCase.assertThat(stParser.currentToken(), Matchers.equalTo(null));
        stParser.close();
        return aggregatorFactory.significanceHeuristic();
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return new NamedXContentRegistry(new SearchModule(Settings.EMPTY, Collections.emptyList()).getNamedXContents());
    }

    @Override
    protected NamedWriteableRegistry writableRegistry() {
        return new NamedWriteableRegistry(new SearchModule(Settings.EMPTY, Collections.emptyList()).getNamedWriteables());
    }

    protected void testBackgroundAssertions(SignificanceHeuristic heuristicIsSuperset, SignificanceHeuristic heuristicNotSuperset) {
        long[] values;
        try {
            heuristicIsSuperset.getScore(2L, 3L, 1L, 4L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("subsetFreq > supersetFreq"));
        }
        try {
            heuristicIsSuperset.getScore(1L, 4L, 2L, 3L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("subsetSize > supersetSize"));
        }
        try {
            heuristicIsSuperset.getScore(2L, 1L, 3L, 4L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("subsetFreq > subsetSize"));
        }
        try {
            heuristicIsSuperset.getScore(1L, 2L, 4L, 3L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("supersetFreq > supersetSize"));
        }
        try {
            heuristicIsSuperset.getScore(1L, 3L, 4L, 4L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException assertionError) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)assertionError.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)assertionError.getMessage().contains("supersetFreq - subsetFreq > supersetSize - subsetSize"));
        }
        try {
            int idx = AbstractSignificanceHeuristicTestCase.randomInt(3);
            values = new long[]{1L, 2L, 3L, 4L};
            int n = idx;
            values[n] = values[n] * -1L;
            heuristicIsSuperset.getScore(values[0], values[1], values[2], values[3]);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("Frequencies of subset and superset must be positive"));
        }
        try {
            heuristicNotSuperset.getScore(2L, 1L, 3L, 4L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("subsetFreq > subsetSize"));
        }
        try {
            heuristicNotSuperset.getScore(1L, 2L, 4L, 3L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("supersetFreq > supersetSize"));
        }
        try {
            int idx = AbstractSignificanceHeuristicTestCase.randomInt(3);
            values = new long[]{1L, 2L, 3L, 4L};
            int n = idx;
            values[n] = values[n] * -1L;
            heuristicNotSuperset.getScore(values[0], values[1], values[2], values[3]);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("Frequencies of subset and superset must be positive"));
        }
    }

    protected void testAssertions(SignificanceHeuristic heuristic) {
        try {
            int idx = AbstractSignificanceHeuristicTestCase.randomInt(3);
            long[] values = new long[]{1L, 2L, 3L, 4L};
            int n = idx;
            values[n] = values[n] * -1L;
            heuristic.getScore(values[0], values[1], values[2], values[3]);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("Frequencies of subset and superset must be positive"));
        }
        try {
            heuristic.getScore(1L, 2L, 4L, 3L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("supersetFreq > supersetSize"));
        }
        try {
            heuristic.getScore(2L, 1L, 3L, 4L);
            AbstractSignificanceHeuristicTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractSignificanceHeuristicTestCase.assertNotNull((Object)illegalArgumentException.getMessage());
            AbstractSignificanceHeuristicTestCase.assertTrue((boolean)illegalArgumentException.getMessage().contains("subsetFreq > subsetSize"));
        }
    }

    private class StringTestAggFactory
    extends TestAggFactory<SignificantStringTerms, SignificantStringTerms.Bucket> {
        private StringTestAggFactory(AbstractSignificanceHeuristicTestCase abstractSignificanceHeuristicTestCase) {
            super(abstractSignificanceHeuristicTestCase);
        }

        @Override
        SignificantStringTerms createAggregation(SignificanceHeuristic significanceHeuristic, long subsetSize, long supersetSize, List<SignificantStringTerms.Bucket> buckets) {
            return new SignificantStringTerms("sig_terms", 2, -1L, Collections.emptyMap(), DocValueFormat.RAW, subsetSize, supersetSize, significanceHeuristic, buckets);
        }

        @Override
        SignificantStringTerms.Bucket createBucket(long subsetDF, long supersetDF, long label) {
            return new SignificantStringTerms.Bucket(new BytesRef(Long.toString(label).getBytes(StandardCharsets.UTF_8)), subsetDF, supersetDF, InternalAggregations.EMPTY, DocValueFormat.RAW, 0.0);
        }
    }

    private class LongTestAggFactory
    extends TestAggFactory<SignificantLongTerms, SignificantLongTerms.Bucket> {
        private LongTestAggFactory(AbstractSignificanceHeuristicTestCase abstractSignificanceHeuristicTestCase) {
            super(abstractSignificanceHeuristicTestCase);
        }

        @Override
        SignificantLongTerms createAggregation(SignificanceHeuristic significanceHeuristic, long subsetSize, long supersetSize, List<SignificantLongTerms.Bucket> buckets) {
            return new SignificantLongTerms("sig_terms", 2, -1L, Collections.emptyMap(), DocValueFormat.RAW, subsetSize, supersetSize, significanceHeuristic, buckets);
        }

        @Override
        SignificantLongTerms.Bucket createBucket(long subsetDF, long supersetDF, long label) {
            return new SignificantLongTerms.Bucket(subsetDF, supersetDF, label, InternalAggregations.EMPTY, DocValueFormat.RAW, 0.0);
        }
    }

    private abstract class TestAggFactory<A extends InternalSignificantTerms<A, B>, B extends InternalSignificantTerms.Bucket<B>> {
        private TestAggFactory(AbstractSignificanceHeuristicTestCase abstractSignificanceHeuristicTestCase) {
        }

        final A createAggregation(SignificanceHeuristic significanceHeuristic, long subsetSize, long supersetSize, int bucketCount, BiFunction<TestAggFactory<?, B>, Integer, B> bucketFactory) {
            List buckets = IntStream.range(0, bucketCount).mapToObj(i -> (InternalSignificantTerms.Bucket)bucketFactory.apply(this, i)).collect(Collectors.toList());
            return this.createAggregation(significanceHeuristic, subsetSize, supersetSize, buckets);
        }

        abstract A createAggregation(SignificanceHeuristic var1, long var2, long var4, List<B> var6);

        abstract B createBucket(long var1, long var3, long var5);
    }
}

