/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.TestProjectResolvers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.StoredScriptSource;

public class MockScriptService
extends ScriptService {
    public MockScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts) {
        super(settings, engines, contexts, () -> 1L, TestProjectResolvers.DEFAULT_PROJECT_ONLY);
    }

    boolean compilationLimitsEnabled() {
        return false;
    }

    public static <T> MockScriptService singleContext(final ScriptContext<T> context, final Function<String, T> compile, final Map<String, StoredScriptSource> storedLookup) {
        ScriptEngine engine = new ScriptEngine(){

            public String getType() {
                return "lang";
            }

            public <FactoryType> FactoryType compile(String name, String code, ScriptContext<FactoryType> context2, Map<String, String> params) {
                return (FactoryType)context2.factoryClazz.cast(compile.apply(code));
            }

            public Set<ScriptContext<?>> getSupportedContexts() {
                return Set.of(context);
            }
        };
        return new MockScriptService(Settings.EMPTY, Map.of("lang", engine), Map.of(context.name, context)){

            protected StoredScriptSource getScriptFromClusterState(ProjectId projectId, String id) {
                return (StoredScriptSource)storedLookup.get(id);
            }
        };
    }

    public static class TestPlugin
    extends Plugin {
    }
}

