/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.elasticsearch.Version;

public class PluginTestUtil {
    public static void writePluginProperties(Path pluginDir, String ... stringProps) throws IOException {
        PluginTestUtil.writeProperties(pluginDir.resolve("plugin-descriptor.properties"), stringProps);
    }

    public static void writeStablePluginProperties(Path pluginDir, String ... stringProps) throws IOException {
        PluginTestUtil.writeProperties(pluginDir.resolve("stable-plugin-descriptor.properties"), stringProps);
    }

    public static void writeSimplePluginDescriptor(Path pluginDir, String name, String classname) throws IOException {
        PluginTestUtil.writePluginProperties(pluginDir, "description", "description", "name", name, "version", "1.0.0", "elasticsearch.version", Version.CURRENT.toString(), "java.version", System.getProperty("java.specification.version"), "classname", classname);
    }

    private static void writeProperties(Path propertiesFile, String ... stringProps) throws IOException {
        assert (stringProps.length % 2 == 0);
        Files.createDirectories(propertiesFile.getParent(), new FileAttribute[0]);
        Properties properties = new Properties();
        for (int i = 0; i < stringProps.length; i += 2) {
            String value = stringProps[i + 1];
            if (value == null) continue;
            properties.put(stringProps[i], stringProps[i + 1]);
        }
        try (OutputStream out = Files.newOutputStream(propertiesFile, new OpenOption[0]);){
            properties.store(out, "");
        }
    }

    public static void writeNamedComponentsFile(Path pluginDir, String namedComponentsJson) throws IOException {
        Path namedComponentsFile = pluginDir.resolve("named_components.json");
        Files.writeString(namedComponentsFile, (CharSequence)namedComponentsJson, new OpenOption[0]);
    }
}

