/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.datageneration.DataGeneratorSpecification;
import org.elasticsearch.datageneration.DocumentGenerator;
import org.elasticsearch.datageneration.Mapping;
import org.elasticsearch.datageneration.MappingGenerator;
import org.elasticsearch.datageneration.Template;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.index.mapper.BlockLoaderTestRunner;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public abstract class BlockLoaderTestCase
extends MapperServiceTestCase {
    private static final MappedFieldType.FieldExtractPreference[] PREFERENCES = new MappedFieldType.FieldExtractPreference[]{MappedFieldType.FieldExtractPreference.NONE, MappedFieldType.FieldExtractPreference.DOC_VALUES, MappedFieldType.FieldExtractPreference.STORED};
    private final String fieldType;
    protected final Params params;
    private final Collection<DataSourceHandler> customDataSourceHandlers;
    private final BlockLoaderTestRunner runner;
    private final String fieldName;

    @ParametersFactory(argumentFormatting="preference=%s")
    public static List<Object[]> args() {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (boolean syntheticSource : new boolean[]{false, true}) {
            for (MappedFieldType.FieldExtractPreference preference : PREFERENCES) {
                args.add(new Object[]{new Params(syntheticSource, preference)});
            }
        }
        return args;
    }

    protected BlockLoaderTestCase(String fieldType, Params params) {
        this(fieldType, List.of(), params);
    }

    protected BlockLoaderTestCase(String fieldType, Collection<DataSourceHandler> customDataSourceHandlers, Params params) {
        this.fieldType = fieldType;
        this.params = params;
        this.customDataSourceHandlers = customDataSourceHandlers;
        this.runner = new BlockLoaderTestRunner(params, BlockLoaderTestCase.randomBoolean());
        this.fieldName = BlockLoaderTestCase.randomAlphaOfLengthBetween(5, 10);
    }

    @Override
    public void testFieldHasValue() {
        BlockLoaderTestCase.assumeTrue((String)"random test inherited from MapperServiceTestCase", (boolean)false);
    }

    @Override
    public void testFieldHasValueWithEmptyFieldInfos() {
        BlockLoaderTestCase.assumeTrue((String)"random test inherited from MapperServiceTestCase", (boolean)false);
    }

    public void testBlockLoader() throws IOException {
        Template template = new Template(Map.of(this.fieldName, new Template.Leaf(this.fieldName, this.fieldType)));
        DataGeneratorSpecification specification = BlockLoaderTestCase.buildSpecification(this.customDataSourceHandlers);
        Mapping mapping = new MappingGenerator(specification).generate(template);
        Map<String, Object> document = new DocumentGenerator(specification).generate(template, mapping);
        Object expected = this.expected(mapping.lookup().get(this.fieldName), this.getFieldValue(document, this.fieldName), new TestContext(false, false));
        XContentBuilder mappingXContent = XContentBuilder.builder((XContent)XContentType.JSON.xContent()).map(mapping.raw());
        MapperService mapperService = this.params.syntheticSource ? this.createSytheticSourceMapperService(mappingXContent) : this.createMapperService(mappingXContent);
        this.runner.runTest(mapperService, document, expected, this.fieldName);
    }

    public void testBlockLoaderForFieldInObject() throws IOException {
        int depth = BlockLoaderTestCase.randomIntBetween(0, 3);
        HashMap<String, Template.Entry> currentLevel = new HashMap<String, Template.Entry>();
        Map<String, Template.Entry> top = Map.of("top", new Template.Object("top", false, currentLevel));
        StringBuilder fullFieldName = new StringBuilder("top");
        int currentDepth = 0;
        while (currentDepth++ < depth) {
            fullFieldName.append('.').append("level").append(currentDepth);
            HashMap<String, Template.Entry> nextLevel = new HashMap<String, Template.Entry>();
            currentLevel.put("level" + currentDepth, new Template.Object("level" + currentDepth, false, nextLevel));
            currentLevel = nextLevel;
        }
        fullFieldName.append('.').append(this.fieldName);
        currentLevel.put(this.fieldName, new Template.Leaf(this.fieldName, this.fieldType));
        Template template = new Template(top);
        DataGeneratorSpecification specification = BlockLoaderTestCase.buildSpecification(this.customDataSourceHandlers);
        Mapping mapping = new MappingGenerator(specification).generate(template);
        Map<String, Object> document = new DocumentGenerator(specification).generate(template, mapping);
        TestContext testContext = new TestContext(false, false);
        if (this.params.syntheticSource && BlockLoaderTestCase.randomBoolean()) {
            Map docMapping = (Map)mapping.raw().get("_doc");
            Map topLevelMapping = (Map)((Map)docMapping.get("properties")).get("top");
            topLevelMapping.put("synthetic_source_keep", "all");
            testContext = new TestContext(true, false);
        }
        XContentBuilder mappingXContent = XContentBuilder.builder((XContent)XContentType.JSON.xContent()).map(mapping.raw());
        MapperService mapperService = this.params.syntheticSource ? this.createSytheticSourceMapperService(mappingXContent) : this.createMapperService(mappingXContent);
        Object expected = this.expected(mapping.lookup().get(fullFieldName.toString()), this.getFieldValue(document, fullFieldName.toString()), testContext);
        this.runner.runTest(mapperService, document, expected, fullFieldName.toString());
    }

    public void testBlockLoaderOfMultiField() throws IOException {
        Template template = new Template(Map.of("parent", new Template.Leaf("parent", this.fieldType)));
        ArrayList<DataSourceHandler> customHandlers = new ArrayList<DataSourceHandler>();
        customHandlers.add(new DataSourceHandler(){

            @Override
            public DataSourceResponse.LeafMappingParametersGenerator handle(DataSourceRequest.LeafMappingParametersGenerator request) {
                if (!request.fieldName().equals("parent")) {
                    return null;
                }
                return new DataSourceResponse.LeafMappingParametersGenerator(() -> {
                    DataSource dataSource = request.dataSource();
                    Map<String, Object> mapping = dataSource.get(new DataSourceRequest.LeafMappingParametersGenerator(dataSource, "_field", request.fieldType(), request.eligibleCopyToFields(), request.dynamicMapping())).mappingGenerator().get();
                    HashMap<String, Object> parentMapping = new HashMap<String, Object>(mapping);
                    HashMap<String, Object> multiFieldMapping = new HashMap<String, Object>(mapping);
                    multiFieldMapping.put("type", BlockLoaderTestCase.this.fieldType);
                    multiFieldMapping.remove("fields");
                    parentMapping.put("fields", Map.of("mf", multiFieldMapping));
                    return parentMapping;
                });
            }
        });
        customHandlers.addAll(this.customDataSourceHandlers);
        DataGeneratorSpecification specification = BlockLoaderTestCase.buildSpecification(customHandlers);
        Mapping mapping = new MappingGenerator(specification).generate(template);
        Map fieldMapping = (Map)((Map)mapping.lookup().get("parent").get("fields")).get("mf");
        Map<String, Object> document = new DocumentGenerator(specification).generate(template, mapping);
        Object expected = this.expected(fieldMapping, this.getFieldValue(document, "parent"), new TestContext(false, true));
        XContentBuilder mappingXContent = XContentBuilder.builder((XContent)XContentType.JSON.xContent()).map(mapping.raw());
        MapperService mapperService = this.params.syntheticSource ? this.createSytheticSourceMapperService(mappingXContent) : this.createMapperService(mappingXContent);
        this.runner.runTest(mapperService, document, expected, "parent.mf");
    }

    public static DataGeneratorSpecification buildSpecification(Collection<DataSourceHandler> customHandlers) {
        return DataGeneratorSpecification.builder().withFullyDynamicMapping(false).withDataSourceHandlers(List.of(new DataSourceHandler(){

            @Override
            public DataSourceResponse.DynamicMappingGenerator handle(DataSourceRequest.DynamicMappingGenerator request) {
                return new DataSourceResponse.DynamicMappingGenerator(isObject -> false);
            }

            @Override
            public DataSourceResponse.ObjectMappingParametersGenerator handle(DataSourceRequest.ObjectMappingParametersGenerator request) {
                return new DataSourceResponse.ObjectMappingParametersGenerator(HashMap::new);
            }
        })).withDataSourceHandlers(customHandlers).build();
    }

    protected abstract Object expected(Map<String, Object> var1, Object var2, TestContext var3);

    protected static Object maybeFoldList(List<?> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list;
    }

    protected Object getFieldValue(Map<String, Object> document, String fieldName) {
        ArrayList<Object> rawValues = new ArrayList<Object>();
        this.processLevel(document, fieldName, rawValues);
        if (rawValues.size() == 1) {
            return rawValues.get(0);
        }
        return rawValues.stream().flatMap(v -> {
            Stream<Object> stream;
            if (v instanceof List) {
                List l = (List)v;
                stream = l.stream();
            } else {
                stream = Stream.of(v);
            }
            return stream;
        }).toList();
    }

    private void processLevel(Map<String, Object> level, String field, ArrayList<Object> values) {
        if (!field.contains(".")) {
            Object value = level.get(field);
            values.add(value);
            return;
        }
        String nameInLevel = field.split("\\.")[0];
        Object entry = level.get(nameInLevel);
        if (entry instanceof Map) {
            Map m = (Map)entry;
            this.processLevel(m, field.substring(field.indexOf(46) + 1), values);
        }
        if (entry instanceof List) {
            List l = (List)entry;
            for (Object object : l) {
                this.processLevel((Map)object, field.substring(field.indexOf(46) + 1), values);
            }
        }
    }

    public static boolean hasDocValues(Map<String, Object> fieldMapping, boolean defaultValue) {
        Object value = fieldMapping.getOrDefault("doc_values", defaultValue);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof Map) {
            return true;
        }
        throw new IllegalArgumentException("Unexpected value [" + String.valueOf(value) + "] for mapping parameter [doc_values]");
    }

    public record Params(boolean syntheticSource, MappedFieldType.FieldExtractPreference preference) {
    }

    public record TestContext(boolean forceFallbackSyntheticSource, boolean isMultifield) {
    }
}

