/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo;

import java.util.ArrayList;
import java.util.function.Function;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.elasticsearch.geo.GeometryPointCountVisitor;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geo.XShapeTestUtil;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.test.ESTestCase;

public class ShapeTestUtils {
    public static final double MIN_VALID_AREA = 1.0E-10;

    public static double randomValue() {
        return XShapeTestUtil.nextDouble();
    }

    public static Point randomPoint() {
        return ShapeTestUtils.randomPoint(ESTestCase.randomBoolean());
    }

    public static Point randomPoint(boolean hasAlt) {
        if (hasAlt) {
            return new Point(ShapeTestUtils.randomValue(), ShapeTestUtils.randomValue(), ShapeTestUtils.randomAlt());
        }
        return new Point(ShapeTestUtils.randomValue(), ShapeTestUtils.randomValue());
    }

    public static Point randomPointNotExtreme(boolean hasAlt) {
        return ESTestCase.randomValueOtherThanMany(ShapeTestUtils::extremePoint, () -> ShapeTestUtils.randomPoint(hasAlt));
    }

    public static Point randomPointNotExtreme() {
        return ShapeTestUtils.randomPointNotExtreme(ESTestCase.randomBoolean());
    }

    public static boolean extremePoint(Point point) {
        double max = 3.4028235931503486E36;
        double min = -3.4028235931503486E36;
        return point.getLon() > max || point.getLon() < min || point.getLat() > max || point.getLat() < min;
    }

    public static double randomAlt() {
        return ESTestCase.randomDouble() * (double)0.001f;
    }

    public static Circle randomCircle(boolean hasAlt) {
        XYCircle luceneCircle = XShapeTestUtil.nextCircle();
        if (hasAlt) {
            return new Circle((double)luceneCircle.getX(), (double)luceneCircle.getY(), ShapeTestUtils.randomAlt(), (double)luceneCircle.getRadius());
        }
        return new Circle((double)luceneCircle.getX(), (double)luceneCircle.getY(), (double)luceneCircle.getRadius());
    }

    public static Line randomLine(boolean hasAlts) {
        XYPolygon lucenePolygon = XShapeTestUtil.nextPolygon();
        int size = lucenePolygon.numPoints() - 1;
        double[] x = new double[size];
        double[] y = new double[size];
        double[] alts = hasAlts ? new double[size] : null;
        for (int i = 0; i < size; ++i) {
            x[i] = lucenePolygon.getPolyX(i);
            y[i] = lucenePolygon.getPolyY(i);
            if (!hasAlts) continue;
            alts[i] = ShapeTestUtils.randomAlt();
        }
        if (hasAlts) {
            return new Line(x, y, alts);
        }
        return new Line(x, y);
    }

    public static Polygon randomPolygon(boolean hasAlt) {
        XYPolygon lucenePolygon = ESTestCase.randomValueOtherThanMany(p -> ShapeTestUtils.area(p) <= 1.0E-10, XShapeTestUtil::nextPolygon);
        if (lucenePolygon.numHoles() > 0) {
            XYPolygon[] luceneHoles = lucenePolygon.getHoles();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 0; i < lucenePolygon.numHoles(); ++i) {
                XYPolygon poly = luceneHoles[i];
                holes.add(GeometryTestUtils.linearRing(ShapeTestUtils.floatsToDoubles(poly.getPolyX()), ShapeTestUtils.floatsToDoubles(poly.getPolyY()), hasAlt));
            }
            return new Polygon(GeometryTestUtils.linearRing(ShapeTestUtils.floatsToDoubles(lucenePolygon.getPolyX()), ShapeTestUtils.floatsToDoubles(lucenePolygon.getPolyY()), hasAlt), holes);
        }
        return new Polygon(GeometryTestUtils.linearRing(ShapeTestUtils.floatsToDoubles(lucenePolygon.getPolyX()), ShapeTestUtils.floatsToDoubles(lucenePolygon.getPolyY()), hasAlt));
    }

    public static double area(XYPolygon p) {
        double windingSum = 0.0;
        int numPts = p.numPoints() - 1;
        for (int i = 0; i < numPts; ++i) {
            windingSum += (double)(p.getPolyX(i) * p.getPolyY(i + 1) - p.getPolyY(i) * p.getPolyX(i + 1));
        }
        return Math.abs(windingSum / 2.0);
    }

    public static double[] floatsToDoubles(float[] f) {
        double[] d = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            d[i] = f[i];
        }
        return d;
    }

    public static Rectangle randomRectangle() {
        XYRectangle rectangle = XShapeTestUtil.nextBox();
        return new Rectangle((double)rectangle.minX, (double)rectangle.maxX, (double)rectangle.maxY, (double)rectangle.minY);
    }

    public static MultiPoint randomMultiPoint(boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(3, 10);
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            points.add(ShapeTestUtils.randomPoint(hasAlt));
        }
        return new MultiPoint(points);
    }

    public static MultiLine randomMultiLine(boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(3, 10);
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 0; i < size; ++i) {
            lines.add(ShapeTestUtils.randomLine(hasAlt));
        }
        return new MultiLine(lines);
    }

    public static MultiPolygon randomMultiPolygon(boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(3, 10);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < size; ++i) {
            polygons.add(ShapeTestUtils.randomPolygon(hasAlt));
        }
        return new MultiPolygon(polygons);
    }

    public static GeometryCollection<Geometry> randomGeometryCollection(boolean hasAlt) {
        return ShapeTestUtils.randomGeometryCollection(0, hasAlt);
    }

    private static GeometryCollection<Geometry> randomGeometryCollection(int level, boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(1, 10);
        ArrayList<Geometry> shapes = new ArrayList<Geometry>();
        for (int i = 0; i < size; ++i) {
            shapes.add(ShapeTestUtils.randomGeometry(level, hasAlt));
        }
        return new GeometryCollection(shapes);
    }

    public static Geometry randomGeometry(boolean hasAlt) {
        return ShapeTestUtils.randomGeometry(0, hasAlt);
    }

    public static Geometry randomGeometry(boolean hasAlt, int maxPoints) {
        GeometryPointCountVisitor pointCounter = new GeometryPointCountVisitor();
        return ESTestCase.randomValueOtherThanMany(g -> (Integer)g.visit((GeometryVisitor)pointCounter) > maxPoints, () -> ShapeTestUtils.randomGeometry(0, hasAlt));
    }

    protected static Geometry randomGeometry(int level, boolean hasAlt) {
        Function geometry = ESTestCase.randomFrom(ShapeTestUtils::randomLine, ShapeTestUtils::randomPoint, ShapeTestUtils::randomPolygon, ShapeTestUtils::randomMultiLine, ShapeTestUtils::randomMultiPoint, ShapeTestUtils::randomMultiPolygon, hasAlt ? ShapeTestUtils::randomPoint : b -> ShapeTestUtils.randomRectangle(), level < 3 ? b -> ShapeTestUtils.randomGeometryCollection(level + 1, b) : ShapeTestUtils::randomPoint);
        return (Geometry)geometry.apply(hasAlt);
    }

    public static Geometry randomGeometryWithoutCircle(boolean hasAlt) {
        return ShapeTestUtils.randomGeometryWithoutCircle(0, hasAlt);
    }

    public static Geometry randomGeometryWithoutCircle(int level, boolean hasAlt) {
        Function geometry = ESTestCase.randomFrom(ShapeTestUtils::randomPoint, ShapeTestUtils::randomMultiPoint, ShapeTestUtils::randomLine, ShapeTestUtils::randomMultiLine, ShapeTestUtils::randomPolygon, ShapeTestUtils::randomMultiPolygon, hasAlt ? ShapeTestUtils::randomPoint : b -> ShapeTestUtils.randomRectangle(), level < 3 ? b -> ShapeTestUtils.randomGeometryCollectionWithoutCircle(level + 1, hasAlt) : ShapeTestUtils::randomPoint);
        return (Geometry)geometry.apply(hasAlt);
    }

    public static GeometryCollection<Geometry> randomGeometryCollectionWithoutCircle(boolean hasAlt) {
        return ShapeTestUtils.randomGeometryCollectionWithoutCircle(0, hasAlt);
    }

    protected static GeometryCollection<Geometry> randomGeometryCollectionWithoutCircle(int level, boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(1, 10);
        ArrayList<Geometry> shapes = new ArrayList<Geometry>();
        for (int i = 0; i < size; ++i) {
            shapes.add(ShapeTestUtils.randomGeometryWithoutCircle(level, hasAlt));
        }
        return new GeometryCollection(shapes);
    }
}

