/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class Messages {
    public static String formatErrorMessage(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings, String errorMessage) {
        return "Error [" + errorMessage + "] actual mappings [" + Strings.toString((XContentBuilder)actualMappings) + "] actual settings [" + Strings.toString((ToXContent)actualSettings.build()) + "] expected mappings [" + Strings.toString((XContentBuilder)expectedMappings) + "] expected settings [" + Strings.toString((ToXContent)expectedSettings.build()) + "] ";
    }

    public static String prettyPrintArrays(Object[] actualArray, Object[] expectedArray) {
        return "actual: " + Messages.prettyPrintCollection(Arrays.asList(actualArray)) + ", expected: " + Messages.prettyPrintCollection(Arrays.asList(expectedArray));
    }

    public static <T> String prettyPrintCollections(Collection<T> actualList, Collection<T> expectedList) {
        return "actual: " + Messages.prettyPrintCollection(actualList) + ", expected: " + Messages.prettyPrintCollection(expectedList);
    }

    private static <T> String prettyPrintCollection(Collection<T> list) {
        return "[" + list.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }
}

