/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class BytesReferenceTestUtils
extends Enum<BytesReferenceTestUtils> {
    private static final /* synthetic */ BytesReferenceTestUtils[] $VALUES;

    public static BytesReferenceTestUtils[] values() {
        return (BytesReferenceTestUtils[])$VALUES.clone();
    }

    public static BytesReferenceTestUtils valueOf(String name) {
        return Enum.valueOf(BytesReferenceTestUtils.class, name);
    }

    public static Matcher<BytesReference> equalBytes(final BytesReference expected) {
        return new BaseMatcher<BytesReference>(){

            public boolean matches(Object actual) {
                return Objects.equals(expected, actual);
            }

            public void describeTo(Description description) {
                if (expected == null) {
                    description.appendValue(null);
                } else {
                    this.appendBytesReferenceDescription(expected, description);
                }
            }

            private void appendBytesReferenceDescription(BytesReference bytesReference, Description description) {
                StringBuilder stringBuilder = new StringBuilder("BytesReference[");
                BytesRefIterator iterator = bytesReference.iterator();
                boolean first = true;
                try {
                    BytesRef bytesRef;
                    while ((bytesRef = iterator.next()) != null) {
                        for (int i = 0; i < bytesRef.length; ++i) {
                            if (first) {
                                first = false;
                            } else {
                                stringBuilder.append(' ');
                            }
                            stringBuilder.append(Strings.format((String)"%02x", (Object[])new Object[]{bytesRef.bytes[bytesRef.offset + i]}));
                        }
                    }
                    description.appendText(stringBuilder.append(']').toString());
                }
                catch (IOException e) {
                    throw new AssertionError("no IO happens here", e);
                }
            }

            public void describeMismatch(Object item, Description description) {
                description.appendText("was ");
                if (item instanceof BytesReference) {
                    BytesReference bytesReference = (BytesReference)item;
                    this.appendBytesReferenceDescription(bytesReference, description);
                } else {
                    description.appendValue(item);
                }
            }
        };
    }

    private static /* synthetic */ BytesReferenceTestUtils[] $values() {
        return new BytesReferenceTestUtils[0];
    }

    static {
        $VALUES = BytesReferenceTestUtils.$values();
    }
}

