/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.project;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedRunnable;

public final class TestProjectResolvers {
    public static final ProjectResolver DEFAULT_PROJECT_ONLY = TestProjectResolvers.singleProject(() -> Metadata.DEFAULT_PROJECT_ID, true);
    private static final ProjectResolver ALWAYS_THROW = new ProjectResolver(){

        public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
            throw new UnsupportedOperationException("Method on the dummy ProjectResolver is not meant to be invoked");
        }

        public ProjectId getProjectId() {
            throw new UnsupportedOperationException("Method on the dummy ProjectResolver is not meant to be invoked");
        }

        public boolean supportsMultipleProjects() {
            throw new UnsupportedOperationException("Method on the dummy ProjectResolver is not meant to be invoked");
        }
    };

    public static ProjectResolver allProjects() {
        return new ProjectResolver(){

            public ProjectId getProjectId() {
                throw new UnsupportedOperationException("This resolver can only be used to resolve multiple projects");
            }

            public Collection<ProjectId> getProjectIds(ClusterState clusterState) {
                return clusterState.metadata().projects().keySet();
            }

            public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
                throw new UnsupportedOperationException("Cannot execute on a specific project when using the 'allProjects' resolver");
            }

            public boolean supportsMultipleProjects() {
                return true;
            }
        };
    }

    public static ProjectResolver mustExecuteFirst() {
        return new ProjectResolver(){
            private volatile ProjectId enforceProjectId = null;

            public ProjectId getProjectId() {
                if (this.enforceProjectId == null) {
                    throw new UnsupportedOperationException("Cannot get project-id before it is set");
                }
                return this.enforceProjectId;
            }

            public Collection<ProjectId> getProjectIds(ClusterState clusterState) {
                TestProjectResolvers.checkSingleProject(clusterState.metadata());
                return super.getProjectIds(clusterState);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
                2 var3_3 = this;
                synchronized (var3_3) {
                    if (this.enforceProjectId != null) {
                        throw new IllegalStateException("Cannot nest calls to executeOnProject");
                    }
                    try {
                        this.enforceProjectId = projectId;
                        body.run();
                    }
                    finally {
                        this.enforceProjectId = null;
                    }
                }
            }

            public boolean supportsMultipleProjects() {
                return true;
            }
        };
    }

    public static ProjectResolver alwaysThrow() {
        return ALWAYS_THROW;
    }

    public static ProjectResolver singleProject(ProjectId projectId) {
        return TestProjectResolvers.singleProject(() -> projectId, false);
    }

    public static ProjectResolver singleProject(Supplier<ProjectId> projectId) {
        return TestProjectResolvers.singleProject(projectId, false);
    }

    public static ProjectResolver singleProjectOnly(ProjectId projectId) {
        return TestProjectResolvers.singleProject(() -> projectId, true);
    }

    private static ProjectResolver singleProject(final Supplier<ProjectId> projectIdSupplier, final boolean only) {
        Objects.requireNonNull(projectIdSupplier);
        return new ProjectResolver(){

            public ProjectMetadata getProjectMetadata(Metadata metadata) {
                if (only) {
                    TestProjectResolvers.checkSingleProject(metadata);
                }
                return super.getProjectMetadata(metadata);
            }

            public ProjectId getProjectId() {
                return (ProjectId)projectIdSupplier.get();
            }

            public Collection<ProjectId> getProjectIds(ClusterState clusterState) {
                if (only) {
                    TestProjectResolvers.checkSingleProject(clusterState.metadata());
                }
                return super.getProjectIds(clusterState);
            }

            public <E extends Exception> void executeOnProject(ProjectId otherProjectId, CheckedRunnable<E> body) throws E {
                ProjectId projectId = (ProjectId)projectIdSupplier.get();
                if (!projectId.equals((Object)otherProjectId)) {
                    throw new IllegalArgumentException("Cannot set project id to " + String.valueOf(otherProjectId));
                }
                body.run();
            }

            public boolean supportsMultipleProjects() {
                return !only;
            }
        };
    }

    public static ProjectResolver usingRequestHeader(final ThreadContext threadContext) {
        return new ProjectResolver(){

            public ProjectMetadata getProjectMetadata(Metadata metadata) {
                ProjectId projectId = this.getProjectId();
                ProjectMetadata project = (ProjectMetadata)metadata.projects().get(projectId);
                if (project == null) {
                    throw new IllegalArgumentException("Could not find project with id [" + projectId.id() + "]");
                }
                return project;
            }

            public ProjectId getProjectId() {
                String headerValue = threadContext.getHeader("X-Elastic-Project-Id");
                return headerValue != null ? ProjectId.fromId((String)headerValue) : Metadata.DEFAULT_PROJECT_ID;
            }

            public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
                try (ThreadContext.StoredContext ignore = threadContext.newStoredContext();){
                    threadContext.putHeader("X-Elastic-Project-Id", projectId.id());
                    body.run();
                }
            }

            public boolean supportsMultipleProjects() {
                return true;
            }
        };
    }

    private static void checkSingleProject(Metadata metadata) {
        if (metadata.projects().size() != 1) {
            throw new IllegalStateException("Cluster has multiple projects: [" + String.valueOf(metadata.projects().keySet()) + "]");
        }
    }
}

