/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;

public final class SingleValueMatchQuery
extends Query {
    private static final int MULTI_VALUE_MATCH_COST = 1000;
    private final IndexFieldData<?> fieldData;
    private final Warnings warnings;
    private final String multiValueExceptionMessage;

    public SingleValueMatchQuery(IndexFieldData<?> fieldData, Warnings warnings, String multiValueExceptionMessage) {
        this.fieldData = fieldData;
        this.warnings = warnings;
        this.multiValueExceptionMessage = multiValueExceptionMessage;
    }

    public String toString(String field) {
        StringBuilder builder = new StringBuilder("single_value_match(");
        if (!this.fieldData.getFieldName().equals(field)) {
            builder.append(this.fieldData.getFieldName());
        }
        return builder.append(")").toString();
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) {
        return new ConstantScoreWeight(this, boost){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                LeafFieldData lfd = SingleValueMatchQuery.this.fieldData.load(context);
                if (lfd == null) {
                    return null;
                }
                if (lfd instanceof LeafNumericFieldData) {
                    LeafNumericFieldData n = (LeafNumericFieldData)lfd;
                    return this.scorerSupplier(context, n.getLongValues(), boost, scoreMode);
                }
                if (lfd instanceof LeafOrdinalsFieldData) {
                    LeafOrdinalsFieldData o = (LeafOrdinalsFieldData)lfd;
                    return this.scorerSupplier(context, o.getOrdinalsValues(), boost, scoreMode);
                }
                return this.scorerSupplier(context, lfd.getBytesValues(), boost, scoreMode);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                LeafOrdinalsFieldData o;
                LeafNumericFieldData n;
                LeafFieldData lfd = SingleValueMatchQuery.this.fieldData.load(ctx);
                return lfd instanceof LeafNumericFieldData ? SortedNumericLongValues.unwrapSingleton((SortedNumericLongValues)(n = (LeafNumericFieldData)lfd).getLongValues()) != null : lfd instanceof LeafOrdinalsFieldData && DocValues.unwrapSingleton((SortedSetDocValues)(o = (LeafOrdinalsFieldData)lfd).getOrdinalsValues()) != null;
            }

            private ScorerSupplier scorerSupplier(LeafReaderContext context, SortedNumericLongValues sortedNumerics, float boost2, ScoreMode scoreMode2) throws IOException {
                int maxDoc = context.reader().maxDoc();
                NumericDocValues ndv = DocValues.unwrapSingleton((SortedNumericDocValues)DocValues.getSortedNumeric((LeafReader)context.reader(), (String)SingleValueMatchQuery.this.fieldData.getFieldName()));
                if (ndv != null && ndv.nextDoc() != Integer.MAX_VALUE) {
                    ndv = DocValues.unwrapSingleton((SortedNumericDocValues)DocValues.getSortedNumeric((LeafReader)context.reader(), (String)SingleValueMatchQuery.this.fieldData.getFieldName()));
                    return new DocIdSetIteratorScorerSupplier(boost2, scoreMode2, (DocIdSetIterator)ndv);
                }
                CheckedIntPredicate predicate = doc -> {
                    if (!sortedNumerics.advanceExact(doc)) {
                        return false;
                    }
                    if (sortedNumerics.docValueCount() != 1) {
                        SingleValueMatchQuery.this.registerMultiValueException();
                        return false;
                    }
                    return true;
                };
                return new PredicateScorerSupplier(boost2, scoreMode2, maxDoc, 1000, predicate);
            }

            private ScorerSupplier scorerSupplier(LeafReaderContext context, SortedSetDocValues sortedSetDocValues, float boost2, ScoreMode scoreMode2) throws IOException {
                int maxDoc = context.reader().maxDoc();
                SortedDocValues sdv = DocValues.unwrapSingleton((SortedSetDocValues)DocValues.getSortedSet((LeafReader)context.reader(), (String)SingleValueMatchQuery.this.fieldData.getFieldName()));
                if (sdv != null && sdv.nextDoc() != Integer.MAX_VALUE) {
                    sdv = DocValues.unwrapSingleton((SortedSetDocValues)DocValues.getSortedSet((LeafReader)context.reader(), (String)SingleValueMatchQuery.this.fieldData.getFieldName()));
                    return new DocIdSetIteratorScorerSupplier(boost2, scoreMode2, (DocIdSetIterator)sdv);
                }
                CheckedIntPredicate predicate = doc -> {
                    if (!sortedSetDocValues.advanceExact(doc)) {
                        return false;
                    }
                    if (sortedSetDocValues.docValueCount() != 1) {
                        SingleValueMatchQuery.this.registerMultiValueException();
                        return false;
                    }
                    return true;
                };
                return new PredicateScorerSupplier(boost2, scoreMode2, maxDoc, 1000, predicate);
            }

            private ScorerSupplier scorerSupplier(LeafReaderContext context, SortedBinaryDocValues sortedBinaryDocValues, float boost2, ScoreMode scoreMode2) {
                int maxDoc = context.reader().maxDoc();
                if (FieldData.unwrapSingleton((SortedBinaryDocValues)sortedBinaryDocValues) != null) {
                    return new PredicateScorerSupplier(boost2, scoreMode2, maxDoc, 1000, arg_0 -> ((SortedBinaryDocValues)sortedBinaryDocValues).advanceExact(arg_0));
                }
                CheckedIntPredicate predicate = doc -> {
                    if (!sortedBinaryDocValues.advanceExact(doc)) {
                        return false;
                    }
                    if (sortedBinaryDocValues.docValueCount() != 1) {
                        SingleValueMatchQuery.this.registerMultiValueException();
                        return false;
                    }
                    return true;
                };
                return new PredicateScorerSupplier(boost2, scoreMode2, maxDoc, 1000, predicate);
            }
        };
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        ConstantIndexFieldData cfd;
        IndexFieldData<?> indexFieldData = this.fieldData;
        if (indexFieldData instanceof ConstantIndexFieldData && (cfd = (ConstantIndexFieldData)indexFieldData).getValue() != null) {
            return Queries.ALL_DOCS_INSTANCE;
        }
        for (LeafReaderContext context : indexSearcher.getIndexReader().leaves()) {
            NumericDocValues singleton;
            LeafReader reader = context.reader();
            int maxDoc = reader.maxDoc();
            LeafFieldData lfd = this.fieldData.load(context);
            if (lfd instanceof LeafNumericFieldData) {
                PointValues points;
                singleton = DocValues.unwrapSingleton((SortedNumericDocValues)reader.getSortedNumericDocValues(this.fieldData.getFieldName()));
                if (singleton != null) {
                    singleton.nextDoc();
                    if (singleton.docIDRunEnd() == maxDoc) continue;
                }
                if ((points = reader.getPointValues(this.fieldData.getFieldName())) != null && points.getDocCount() == maxDoc && points.size() == (long)points.getDocCount()) continue;
                return super.rewrite(indexSearcher);
            }
            if (lfd instanceof LeafOrdinalsFieldData) {
                Terms terms;
                singleton = DocValues.unwrapSingleton((SortedSetDocValues)reader.getSortedSetDocValues(this.fieldData.getFieldName()));
                if (singleton != null) {
                    singleton.nextDoc();
                    if (singleton.docIDRunEnd() == maxDoc) continue;
                }
                if ((terms = reader.terms(this.fieldData.getFieldName())) != null && terms.getDocCount() == maxDoc && terms.getSumDocFreq() == (long)terms.getDocCount()) continue;
                return super.rewrite(indexSearcher);
            }
            return super.rewrite(indexSearcher);
        }
        return Queries.ALL_DOCS_INSTANCE;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldData.getFieldName())) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SingleValueMatchQuery other = (SingleValueMatchQuery)((Object)obj);
        return this.fieldData.getFieldName().equals(other.fieldData.getFieldName());
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldData.getFieldName());
    }

    private void registerMultiValueException() {
        this.warnings.registerException(IllegalArgumentException.class, this.multiValueExceptionMessage);
    }

    @FunctionalInterface
    private static interface CheckedIntPredicate {
        public boolean test(int var1) throws IOException;
    }

    private static class PredicateScorerSupplier
    extends ScorerSupplier {
        private final float score;
        private final ScoreMode scoreMode;
        private final int maxDoc;
        private final int matchCost;
        private final CheckedIntPredicate predicate;

        private PredicateScorerSupplier(float score, ScoreMode scoreMode, int maxDoc, int matchCost, CheckedIntPredicate predicate) {
            this.score = score;
            this.scoreMode = scoreMode;
            this.maxDoc = maxDoc;
            this.matchCost = matchCost;
            this.predicate = predicate;
        }

        public Scorer get(long leadCost) {
            TwoPhaseIterator iterator = new TwoPhaseIterator(DocIdSetIterator.all((int)this.maxDoc)){

                public boolean matches() throws IOException {
                    return predicate.test(this.approximation.docID());
                }

                public float matchCost() {
                    return matchCost;
                }
            };
            return new ConstantScoreScorer(this.score, this.scoreMode, iterator);
        }

        public long cost() {
            return this.maxDoc;
        }
    }

    private static class DocIdSetIteratorScorerSupplier
    extends ScorerSupplier {
        private final float score;
        private final ScoreMode scoreMode;
        private final DocIdSetIterator docIdSetIterator;

        private DocIdSetIteratorScorerSupplier(float score, ScoreMode scoreMode, DocIdSetIterator docIdSetIterator) {
            this.score = score;
            this.scoreMode = scoreMode;
            this.docIdSetIterator = docIdSetIterator;
        }

        public Scorer get(long leadCost) {
            return new ConstantScoreScorer(this.score, this.scoreMode, this.docIdSetIterator);
        }

        public long cost() {
            return this.docIdSetIterator.cost();
        }
    }
}

