/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;

public class ValueExtractorForTDigest
implements ValueExtractor {
    private final TDigestBlock block;
    private final BytesRef scratch = new BytesRef();
    private final ReusableTopNEncoderOutput reusableOutput = new ReusableTopNEncoderOutput();

    ValueExtractorForTDigest(TopNEncoder encoder, TDigestBlock block) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE);
        this.block = block;
    }

    @Override
    public void writeValue(BreakingBytesRefBuilder values, int position) {
        if (this.block.isNull(position)) {
            TopNEncoder.DEFAULT_UNSORTABLE.encodeVInt(0, values);
        } else {
            assert (this.block.getValueCount(position) == 1) : "Multi-valued ExponentialHistogram blocks are not supported in TopN";
            TopNEncoder.DEFAULT_UNSORTABLE.encodeVInt(1, values);
            int valueIndex = this.block.getFirstValueIndex(position);
            this.reusableOutput.target = values;
            this.block.serializeTDigest(valueIndex, this.reusableOutput, this.scratch);
        }
    }

    public String toString() {
        return "ValueExtractorForExponentialHistogram";
    }

    private static final class ReusableTopNEncoderOutput
    implements TDigestBlock.SerializedTDigestOutput {
        BreakingBytesRefBuilder target;

        private ReusableTopNEncoderOutput() {
        }

        @Override
        public void appendDouble(double value) {
            TopNEncoder.DEFAULT_UNSORTABLE.encodeDouble(value, this.target);
        }

        @Override
        public void appendLong(long value) {
            TopNEncoder.DEFAULT_UNSORTABLE.encodeLong(value, this.target);
        }

        @Override
        public void appendBytesRef(BytesRef value) {
            TopNEncoder.DEFAULT_UNSORTABLE.encodeBytesRef(value, this.target);
        }
    }
}

