/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractorForAggregateMetricDouble;
import org.elasticsearch.compute.operator.topn.ValueExtractorForBoolean;
import org.elasticsearch.compute.operator.topn.ValueExtractorForBytesRef;
import org.elasticsearch.compute.operator.topn.ValueExtractorForDoc;
import org.elasticsearch.compute.operator.topn.ValueExtractorForDouble;
import org.elasticsearch.compute.operator.topn.ValueExtractorForExponentialHistogram;
import org.elasticsearch.compute.operator.topn.ValueExtractorForFloat;
import org.elasticsearch.compute.operator.topn.ValueExtractorForInt;
import org.elasticsearch.compute.operator.topn.ValueExtractorForLong;
import org.elasticsearch.compute.operator.topn.ValueExtractorForNull;
import org.elasticsearch.compute.operator.topn.ValueExtractorForTDigest;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;

interface ValueExtractor {
    public void writeValue(BreakingBytesRefBuilder var1, int var2);

    @Nullable
    default public RefCounted getRefCountedForShard(int position) {
        return null;
    }

    public static ValueExtractor extractorFor(ElementType elementType, TopNEncoder encoder, boolean inKey, Block block) {
        if (!(elementType == block.elementType() || ElementType.NULL == block.elementType())) {
            throw new IllegalStateException("Expected [" + String.valueOf((Object)elementType) + "] but was [" + String.valueOf((Object)block.elementType()) + "]");
        }
        return switch (block.elementType()) {
            case ElementType.BOOLEAN -> ValueExtractorForBoolean.extractorFor(encoder, inKey, (BooleanBlock)block);
            case ElementType.BYTES_REF -> ValueExtractorForBytesRef.extractorFor(encoder, inKey, (BytesRefBlock)block);
            case ElementType.INT -> ValueExtractorForInt.extractorFor(encoder, inKey, (IntBlock)block);
            case ElementType.LONG -> ValueExtractorForLong.extractorFor(encoder, inKey, (LongBlock)block);
            case ElementType.FLOAT -> ValueExtractorForFloat.extractorFor(encoder, inKey, (FloatBlock)block);
            case ElementType.DOUBLE -> ValueExtractorForDouble.extractorFor(encoder, inKey, (DoubleBlock)block);
            case ElementType.NULL -> new ValueExtractorForNull();
            case ElementType.DOC -> new ValueExtractorForDoc(encoder, ((DocBlock)block).asVector());
            case ElementType.AGGREGATE_METRIC_DOUBLE -> new ValueExtractorForAggregateMetricDouble(encoder, (AggregateMetricDoubleBlock)block);
            case ElementType.EXPONENTIAL_HISTOGRAM -> new ValueExtractorForExponentialHistogram(encoder, (ExponentialHistogramBlock)block);
            case ElementType.TDIGEST -> new ValueExtractorForTDigest(encoder, (TDigestBlock)block);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("No value extractor for [" + String.valueOf((Object)block.elementType()) + "]"));
                }
                throw new UnsupportedOperationException("No value extractor for [" + String.valueOf((Object)block.elementType()) + "]");
            }
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

