/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class EnrichResultBuilderForFloat
extends EnrichResultBuilder {
    private ObjectArray<float[]> cells;

    EnrichResultBuilderForFloat(BlockFactory blockFactory, int channel) {
        super(blockFactory, channel);
        this.cells = blockFactory.bigArrays().newObjectArray(1L);
    }

    @Override
    void addInputPage(IntVector positions, Page page) {
        FloatBlock block = (FloatBlock)page.getBlock(this.channel);
        for (int i = 0; i < positions.getPositionCount(); ++i) {
            int valueCount = block.getValueCount(i);
            if (valueCount == 0) continue;
            int cellPosition = positions.getInt(i);
            this.cells = this.blockFactory.bigArrays().grow(this.cells, (long)(cellPosition + 1));
            float[] oldCell = (float[])this.cells.get((long)cellPosition);
            float[] newCell = this.extendCell(oldCell, valueCount);
            this.cells.set((long)cellPosition, (Object)newCell);
            int dstIndex = oldCell != null ? oldCell.length : 0;
            this.adjustBreaker(RamUsageEstimator.sizeOf((float[])newCell) - (oldCell != null ? RamUsageEstimator.sizeOf((float[])oldCell) : 0L));
            int firstValueIndex = block.getFirstValueIndex(i);
            for (int v = 0; v < valueCount; ++v) {
                newCell[dstIndex + v] = block.getFloat(firstValueIndex + v);
            }
        }
    }

    private float[] extendCell(float[] oldCell, int newValueCount) {
        if (oldCell == null) {
            return new float[newValueCount];
        }
        return Arrays.copyOf(oldCell, oldCell.length + newValueCount);
    }

    private float[] combineCell(float[] first, float[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        float[] result = new float[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private void appendGroupToBlockBuilder(FloatBlock.Builder builder, float[] group) {
        if (group == null) {
            builder.appendNull();
        } else if (group.length == 1) {
            builder.appendFloat(group[0]);
        } else {
            builder.beginPositionEntry();
            for (float v : group) {
                builder.appendFloat(v);
            }
            builder.endPositionEntry();
        }
    }

    private float[] getCellOrNull(int position) {
        return (long)position < this.cells.size() ? (float[])this.cells.get((long)position) : null;
    }

    private Block buildWithSelected(IntBlock selected) {
        try (FloatBlock.Builder builder = this.blockFactory.newFloatBlockBuilder(selected.getPositionCount());){
            block9: for (int i = 0; i < selected.getPositionCount(); ++i) {
                int selectedCount = selected.getValueCount(i);
                switch (selectedCount) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        int groupId = selected.getInt(selected.getFirstValueIndex(i));
                        this.appendGroupToBlockBuilder(builder, this.getCellOrNull(groupId));
                        continue block9;
                    }
                    default: {
                        int firstValueIndex = selected.getFirstValueIndex(i);
                        float[] cell = this.getCellOrNull(selected.getInt(firstValueIndex));
                        for (int p = 1; p < selectedCount; ++p) {
                            int groupId = selected.getInt(firstValueIndex + p);
                            cell = this.combineCell(cell, this.getCellOrNull(groupId));
                        }
                        this.appendGroupToBlockBuilder(builder, cell);
                    }
                }
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private Block buildWithSelected(IntVector selected) {
        try (FloatBlock.Builder builder = this.blockFactory.newFloatBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                this.appendGroupToBlockBuilder(builder, this.getCellOrNull(selected.getInt(i)));
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    @Override
    Block build(IntBlock selected) {
        IntVector vector = selected.asVector();
        if (vector != null) {
            return this.buildWithSelected(vector);
        }
        return this.buildWithSelected(selected);
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.cells, () -> super.close()});
    }
}

