/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilderForBoolean;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilderForBytesRef;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilderForDouble;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilderForFloat;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilderForInt;
import org.elasticsearch.compute.operator.lookup.EnrichResultBuilderForLong;
import org.elasticsearch.core.Releasable;

abstract class EnrichResultBuilder
implements Releasable {
    protected final BlockFactory blockFactory;
    protected final int channel;
    private long usedBytes;

    EnrichResultBuilder(BlockFactory blockFactory, int channel) {
        this.blockFactory = blockFactory;
        this.channel = channel;
    }

    abstract void addInputPage(IntVector var1, Page var2);

    abstract Block build(IntBlock var1);

    final void adjustBreaker(long bytes) {
        this.blockFactory.breaker().addEstimateBytesAndMaybeBreak(bytes, "<<enrich-result>>");
        this.usedBytes += bytes;
    }

    public void close() {
        this.blockFactory.breaker().addWithoutBreaking(-this.usedBytes);
    }

    static EnrichResultBuilder enrichResultBuilder(ElementType elementType, BlockFactory blockFactory, int channel) {
        return switch (elementType) {
            case ElementType.NULL -> new EnrichResultBuilderForNull(blockFactory, channel);
            case ElementType.INT -> new EnrichResultBuilderForInt(blockFactory, channel);
            case ElementType.LONG -> new EnrichResultBuilderForLong(blockFactory, channel);
            case ElementType.DOUBLE -> new EnrichResultBuilderForDouble(blockFactory, channel);
            case ElementType.FLOAT -> new EnrichResultBuilderForFloat(blockFactory, channel);
            case ElementType.BOOLEAN -> new EnrichResultBuilderForBoolean(blockFactory, channel);
            case ElementType.BYTES_REF -> new EnrichResultBuilderForBytesRef(blockFactory, channel);
            default -> throw new IllegalArgumentException("no enrich result builder for [" + String.valueOf((Object)elementType) + "]");
        };
    }

    private static class EnrichResultBuilderForNull
    extends EnrichResultBuilder {
        EnrichResultBuilderForNull(BlockFactory blockFactory, int channel) {
            super(blockFactory, channel);
        }

        @Override
        void addInputPage(IntVector positions, Page page) {
            assert (page.getBlock(this.channel).areAllValuesNull()) : "expected all nulls; but got values";
        }

        @Override
        Block build(IntBlock selected) {
            return this.blockFactory.newConstantNullBlock(selected.getPositionCount());
        }
    }
}

