/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.fuse;

import java.util.HashMap;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.fuse.RrfConfig;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class RrfScoreEvalOperator
extends AbstractPageMappingOperator {
    private final int scorePosition;
    private final int discriminatorPosition;
    private final RrfConfig config;
    private Warnings warnings;
    private final DriverContext driverContext;
    private final String sourceText;
    private final int sourceLine;
    private final int sourceColumn;
    private HashMap<String, Integer> counters = new HashMap();

    public RrfScoreEvalOperator(DriverContext driverContext, int discriminatorPosition, int scorePosition, RrfConfig config, String sourceText, int sourceLine, int sourceColumn) {
        this.scorePosition = scorePosition;
        this.discriminatorPosition = discriminatorPosition;
        this.config = config;
        this.driverContext = driverContext;
        this.sourceText = sourceText;
        this.sourceLine = sourceLine;
        this.sourceColumn = sourceColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page process(Page page) {
        BytesRefBlock discriminatorBlock = (BytesRefBlock)page.getBlock(this.discriminatorPosition);
        DoubleBlock.Builder scores = discriminatorBlock.blockFactory().newDoubleBlockBuilder(discriminatorBlock.getPositionCount());
        for (int i = 0; i < page.getPositionCount(); ++i) {
            Object value = BlockUtils.toJavaObject(discriminatorBlock, i);
            if (value == null) {
                this.warnings().registerException(new IllegalArgumentException("group column has null values; assigning null scores"));
                scores.appendNull();
                continue;
            }
            if (value instanceof List) {
                this.warnings().registerException(new IllegalArgumentException("group column contains multivalued entries; assigning null scores"));
                scores.appendNull();
                continue;
            }
            String discriminator = ((BytesRef)value).utf8ToString();
            int rank = this.counters.getOrDefault(discriminator, 1);
            Double weight = this.config.weights().getOrDefault(discriminator, 1.0);
            scores.appendDouble(1.0 / (this.config.rankConstant() + (double)rank) * weight);
            this.counters.put(discriminator, rank + 1);
        }
        Page newPage = null;
        DoubleBlock scoreBlock = null;
        try {
            scoreBlock = scores.build();
            newPage = page.appendBlock(scoreBlock);
            int[] projections = new int[newPage.getBlockCount() - 1];
            for (int i = 0; i < newPage.getBlockCount() - 1; ++i) {
                projections[i] = i == this.scorePosition ? newPage.getBlockCount() - 1 : i;
            }
            Page page2 = newPage.projectBlocks(projections);
            return page2;
        }
        finally {
            if (newPage != null) {
                newPage.releaseBlocks();
            } else {
                page.releaseBlocks();
            }
            if (scoreBlock == null) {
                Releasables.close((Releasable)scores);
            }
        }
    }

    @Override
    public String toString() {
        return "RrfScoreEvalOperator";
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings(this.driverContext.warningsMode(), this.sourceLine, this.sourceColumn, this.sourceText);
        }
        return this.warnings;
    }

    public record Factory(int discriminatorPosition, int scorePosition, RrfConfig rrfConfig, String sourceText, int sourceLine, int sourceColumn) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new RrfScoreEvalOperator(driverContext, this.discriminatorPosition, this.scorePosition, this.rrfConfig, this.sourceText, this.sourceLine, this.sourceColumn);
        }

        @Override
        public String describe() {
            return "RrfScoreEvalOperator[discriminatorPosition=" + this.discriminatorPosition + ", scorePosition=" + this.scorePosition + ", rrfConfig=" + String.valueOf(this.rrfConfig) + "]";
        }
    }
}

