/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class PlanTimeProfile
implements Writeable,
ToXContentObject {
    private long reductionPlanNanos;
    private long logicalOptimizationNanos;
    private long physicalOptimizationNanos;

    public PlanTimeProfile(long logicalOptimizationNanos, long physicalOptimizationNanos, long reductionPlanNanos) {
        this.logicalOptimizationNanos = logicalOptimizationNanos;
        this.physicalOptimizationNanos = physicalOptimizationNanos;
        this.reductionPlanNanos = reductionPlanNanos;
    }

    public PlanTimeProfile() {
        this.logicalOptimizationNanos = 0L;
        this.physicalOptimizationNanos = 0L;
        this.reductionPlanNanos = 0L;
    }

    public PlanTimeProfile(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLong());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.logicalOptimizationNanos);
        out.writeVLong(this.physicalOptimizationNanos);
        out.writeVLong(this.reductionPlanNanos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.logicalOptimizationNanos > 0L) {
            builder.field("logical_optimization_nanos", this.logicalOptimizationNanos);
        }
        if (this.physicalOptimizationNanos > 0L) {
            builder.field("physical_optimization_nanos", this.physicalOptimizationNanos);
        }
        if (this.reductionPlanNanos > 0L) {
            builder.field("reduction_nanos", this.physicalOptimizationNanos);
        }
        return builder;
    }

    public void addLogicalOptimizationPlanTime(long logicalOptimizationPlanTime) {
        this.logicalOptimizationNanos += logicalOptimizationPlanTime;
    }

    public void addPhysicalOptimizationPlanTime(long physicalOptimizationPlanTime) {
        this.physicalOptimizationNanos += physicalOptimizationPlanTime;
    }

    public void addReductionPlanNanos(long reductionPlanNanos) {
        this.reductionPlanNanos += reductionPlanNanos;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PlanTimeProfile that = (PlanTimeProfile)obj;
        return this.logicalOptimizationNanos == that.logicalOptimizationNanos && this.physicalOptimizationNanos == that.physicalOptimizationNanos && this.reductionPlanNanos == that.reductionPlanNanos;
    }

    public int hashCode() {
        return Objects.hash(this.logicalOptimizationNanos, this.physicalOptimizationNanos, this.reductionPlanNanos);
    }

    public String toString() {
        return "PlanTimeProfile[logicalOptimizationNanos=" + this.logicalOptimizationNanos + ", physicalOptimizationNanos=" + this.physicalOptimizationNanos + ", reductionPlanNanos=" + this.reductionPlanNanos + "]";
    }
}

