/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.operator.DriverSleeps;
import org.elasticsearch.compute.operator.OperatorStatus;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record DriverStatus(String sessionId, String description, String clusterName, String nodeName, long started, long lastUpdated, long cpuNanos, long iterations, Status status, List<OperatorStatus> completedOperators, List<OperatorStatus> activeOperators, DriverSleeps sleeps) implements Task.Status
{
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Task.Status.class, "driver", DriverStatus::readFrom);
    private static final TransportVersion ESQL_DRIVER_NODE_DESCRIPTION = TransportVersion.fromName((String)"esql_driver_node_description");
    private static final TransportVersion ESQL_DRIVER_TASK_DESCRIPTION = TransportVersion.fromName((String)"esql_driver_task_description");

    public static DriverStatus readFrom(StreamInput in) throws IOException {
        return new DriverStatus(in.readString(), in.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION) ? in.readString() : "", in.getTransportVersion().supports(ESQL_DRIVER_NODE_DESCRIPTION) ? in.readString() : "", in.getTransportVersion().supports(ESQL_DRIVER_NODE_DESCRIPTION) ? in.readString() : "", in.readLong(), in.readLong(), in.readVLong(), in.readVLong(), Status.read(in), in.readCollectionAsImmutableList(OperatorStatus::readFrom), in.readCollectionAsImmutableList(OperatorStatus::readFrom), DriverSleeps.read(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.sessionId);
        if (out.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION)) {
            out.writeString(this.description);
        }
        if (out.getTransportVersion().supports(ESQL_DRIVER_NODE_DESCRIPTION)) {
            out.writeString(this.clusterName);
            out.writeString(this.nodeName);
        }
        out.writeLong(this.started);
        out.writeLong(this.lastUpdated);
        out.writeVLong(this.cpuNanos);
        out.writeVLong(this.iterations);
        this.status.writeTo(out);
        out.writeCollection(this.completedOperators);
        out.writeCollection(this.activeOperators);
        this.sleeps.writeTo(out);
    }

    public String getWriteableName() {
        return DriverStatus.ENTRY.name;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("session_id", this.sessionId);
        builder.field("description", this.description);
        builder.field("cluster_name", this.clusterName);
        builder.field("node_name", this.nodeName);
        builder.field("started", DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(this.started));
        builder.field("last_updated", DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.formatMillis(this.lastUpdated));
        builder.field("cpu_nanos", this.cpuNanos);
        if (builder.humanReadable()) {
            builder.field("cpu_time", (Object)TimeValue.timeValueNanos((long)this.cpuNanos));
        }
        builder.field("documents_found", this.documentsFound());
        builder.field("values_loaded", this.valuesLoaded());
        builder.field("iterations", this.iterations);
        builder.field("status", (ToXContent)this.status, params);
        builder.startArray("completed_operators");
        for (OperatorStatus completed : this.completedOperators) {
            builder.value((ToXContent)completed);
        }
        builder.endArray();
        builder.startArray("active_operators");
        for (OperatorStatus active : this.activeOperators) {
            builder.value((ToXContent)active);
        }
        builder.endArray();
        builder.field("sleeps", (ToXContent)this.sleeps, params);
        return builder.endObject();
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public long documentsFound() {
        long documentsFound = 0L;
        for (OperatorStatus s : this.completedOperators) {
            documentsFound += s.documentsFound();
        }
        for (OperatorStatus s : this.activeOperators) {
            documentsFound += s.documentsFound();
        }
        return documentsFound;
    }

    public long valuesLoaded() {
        long valuesLoaded = 0L;
        for (OperatorStatus s : this.completedOperators) {
            valuesLoaded += s.valuesLoaded();
        }
        for (OperatorStatus s : this.activeOperators) {
            valuesLoaded += s.valuesLoaded();
        }
        return valuesLoaded;
    }

    public static enum Status implements Writeable,
    ToXContentFragment
    {
        QUEUED,
        STARTING,
        RUNNING,
        ASYNC,
        WAITING,
        DONE;


        public static Status read(StreamInput in) throws IOException {
            return Status.valueOf(in.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.toString());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.toString().toLowerCase(Locale.ROOT));
        }
    }
}

