/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointDetector;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeType;

public class ChangePointOperator
implements Operator {
    private static final Logger logger = LogManager.getLogger(ChangePointOperator.class);
    public static final int INPUT_VALUE_COUNT_LIMIT = 1000;
    private final DriverContext driverContext;
    private final int channel;
    private final String sourceText;
    private final int sourceLine;
    private final int sourceColumn;
    private final Deque<Page> inputPages;
    private final Deque<Page> outputPages;
    private boolean finished;
    private Warnings warnings;

    public ChangePointOperator(DriverContext driverContext, int channel, String sourceText, int sourceLine, int sourceColumn) {
        this.driverContext = driverContext;
        this.channel = channel;
        this.sourceText = sourceText;
        this.sourceLine = sourceLine;
        this.sourceColumn = sourceColumn;
        this.finished = false;
        this.inputPages = new ArrayDeque<Page>();
        this.outputPages = new ArrayDeque<Page>();
        this.warnings = null;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        this.inputPages.add(page);
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            this.createOutputPages();
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.outputPages.isEmpty();
    }

    @Override
    public Page getOutput() {
        if (!this.finished || this.outputPages.isEmpty()) {
            return null;
        }
        return this.outputPages.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createOutputPages() {
        boolean tooManyValues;
        int valuesCount = 0;
        for (Page page : this.inputPages) {
            valuesCount += page.getPositionCount();
        }
        boolean bl = tooManyValues = valuesCount > 1000;
        if (tooManyValues) {
            valuesCount = 1000;
        }
        ArrayList<Double> values = new ArrayList<Double>(valuesCount);
        ArrayList<Integer> bucketIndexes = new ArrayList<Integer>(valuesCount);
        int valuesIndex = 0;
        boolean hasNulls = false;
        boolean hasMultivalued = false;
        for (Page inputPage : this.inputPages) {
            Object inputBlock = inputPage.getBlock(this.channel);
            for (int i = 0; i < inputBlock.getPositionCount() && valuesIndex < valuesCount; ++i) {
                Object value = BlockUtils.toJavaObject(inputBlock, i);
                if (value == null) {
                    hasNulls = true;
                    ++valuesIndex;
                    continue;
                }
                if (value instanceof List) {
                    hasMultivalued = true;
                    ++valuesIndex;
                    continue;
                }
                values.add(((Number)value).doubleValue());
                bucketIndexes.add(valuesIndex++);
            }
        }
        MlAggsHelper.DoubleBucketValues bucketValues = new MlAggsHelper.DoubleBucketValues(null, values.stream().mapToDouble(Double::doubleValue).toArray(), bucketIndexes.stream().mapToInt(Integer::intValue).toArray());
        ChangeType changeType = ChangePointDetector.getChangeType((MlAggsHelper.DoubleBucketValues)bucketValues);
        int changePointIndex = changeType.changePoint();
        BlockFactory blockFactory = this.driverContext.blockFactory();
        int pageStartIndex = 0;
        while (!this.inputPages.isEmpty()) {
            Page outputPage;
            Page inputPage;
            block34: {
                inputPage = this.inputPages.peek();
                Block changeTypeBlock = null;
                Block changePvalueBlock = null;
                boolean success = false;
                try {
                    block33: {
                        if (pageStartIndex <= changePointIndex && changePointIndex < pageStartIndex + inputPage.getPositionCount()) {
                            try (BytesRefBlock.Builder changeTypeBlockBuilder = blockFactory.newBytesRefBlockBuilder(inputPage.getPositionCount());
                                 DoubleBlock.Builder pvalueBlockBuilder = blockFactory.newDoubleBlockBuilder(inputPage.getPositionCount());){
                                for (int i = 0; i < inputPage.getPositionCount(); ++i) {
                                    if (pageStartIndex + i == changePointIndex) {
                                        changeTypeBlockBuilder.appendBytesRef(new BytesRef((CharSequence)changeType.getWriteableName()));
                                        pvalueBlockBuilder.appendDouble(changeType.pValue());
                                        continue;
                                    }
                                    changeTypeBlockBuilder.appendNull();
                                    pvalueBlockBuilder.appendNull();
                                }
                                changeTypeBlock = changeTypeBlockBuilder.build();
                                changePvalueBlock = pvalueBlockBuilder.build();
                                break block33;
                            }
                        }
                        changeTypeBlock = blockFactory.newConstantNullBlock(inputPage.getPositionCount());
                        changePvalueBlock = blockFactory.newConstantNullBlock(inputPage.getPositionCount());
                    }
                    outputPage = inputPage.appendBlocks(new Block[]{changeTypeBlock, changePvalueBlock});
                    success = true;
                    if (success) break block34;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{changeTypeBlock, changePvalueBlock});
                    }
                    throw throwable;
                }
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{changeTypeBlock, changePvalueBlock});
            }
            this.inputPages.removeFirst();
            this.outputPages.add(outputPage);
            pageStartIndex += inputPage.getPositionCount();
        }
        if (changeType instanceof ChangeType.Indeterminable) {
            ChangeType.Indeterminable indeterminable = (ChangeType.Indeterminable)changeType;
            if (logger.isDebugEnabled()) {
                logger.debug("Change point indeterminable: {}", new Object[]{indeterminable.getReason()});
            }
            this.warnings(false).registerException(new IllegalArgumentException(indeterminable.getReason()));
        }
        if (tooManyValues) {
            if (logger.isDebugEnabled()) {
                logger.debug("Too many values: limit is {}, some values were ignored", new Object[]{1000});
            }
            this.warnings(true).registerException(new IllegalArgumentException("too many values; keeping only first 1000 values"));
        }
        if (hasNulls) {
            if (logger.isDebugEnabled()) {
                logger.debug("Values contain nulls; skipping them");
            }
            this.warnings(true).registerException(new IllegalArgumentException("values contain nulls; skipping them"));
        }
        if (hasMultivalued) {
            if (logger.isDebugEnabled()) {
                logger.debug("Values contain multivalued entries; skipping them");
            }
            this.warnings(true).registerException(new IllegalArgumentException("values contains multivalued entries; skipping them (please consider reducing them with e.g. MV_AVG or MV_SUM)"));
        }
    }

    @Override
    public void close() {
        for (Page page : this.inputPages) {
            page.releaseBlocks();
        }
        for (Page page : this.outputPages) {
            page.releaseBlocks();
        }
    }

    public String toString() {
        return "ChangePointOperator[channel=" + this.channel + "]";
    }

    private Warnings warnings(boolean onlyWarnings) {
        if (this.warnings == null) {
            this.warnings = onlyWarnings ? Warnings.createOnlyWarnings(this.driverContext.warningsMode(), this.sourceLine, this.sourceColumn, this.sourceText) : Warnings.createWarnings(this.driverContext.warningsMode(), this.sourceLine, this.sourceColumn, this.sourceText);
        }
        return this.warnings;
    }

    public record Factory(int channel, String sourceText, int sourceLine, int sourceColumn) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ChangePointOperator(driverContext, this.channel, this.sourceText, this.sourceLine, this.sourceColumn);
        }

        @Override
        public String describe() {
            return "ChangePointOperator[channel=" + this.channel + "]";
        }
    }
}

