/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.mapper.BlockLoader;

public final class SingletonLongBuilder
implements BlockLoader.SingletonLongBuilder,
Releasable,
Block.Builder {
    private final long[] values;
    private final BlockFactory blockFactory;
    private int count;

    public SingletonLongBuilder(int expectedCount, BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
        blockFactory.adjustBreaker(SingletonLongBuilder.valuesSize(expectedCount));
        this.values = new long[expectedCount];
    }

    @Override
    public Block.Builder appendNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder beginPositionEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder endPositionEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long estimatedBytes() {
        return SingletonLongBuilder.valuesSize(this.values.length);
    }

    @Override
    public Block build() {
        if (this.values.length != this.count) {
            throw new IllegalStateException("expected [" + this.values.length + "] values but got [" + this.count + "]");
        }
        return this.blockFactory.newLongArrayVector(this.values, this.count).asBlock();
    }

    public BlockLoader.SingletonLongBuilder appendLong(long value) {
        this.values[this.count++] = value;
        return this;
    }

    public BlockLoader.SingletonLongBuilder appendLongs(long[] values, int from, int length) {
        System.arraycopy(values, from, this.values, this.count, length);
        this.count += length;
        return this;
    }

    public void close() {
        this.blockFactory.adjustBreaker(-SingletonLongBuilder.valuesSize(this.values.length));
    }

    static long valuesSize(int count) {
        return (long)count * 8L;
    }
}

