/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.index.mapper.BlockLoader;

public final class SingletonBytesRefBuilder
implements BlockLoader.SingletonBytesRefBuilder {
    private final int count;
    private final BlockFactory blockFactory;
    private BytesRefArray bytesRefArray;

    public SingletonBytesRefBuilder(int count, BlockFactory blockFactory) {
        this.count = count;
        this.blockFactory = blockFactory;
    }

    public SingletonBytesRefBuilder appendBytesRefs(byte[] bytes, long[] offsets) {
        ByteArray values = this.blockFactory.bigArrays().newByteArrayWrapper(bytes);
        this.bytesRefArray = new BytesRefArray((LongArray)new LongArrayWrapper(offsets), values, (long)this.count, this.blockFactory.bigArrays());
        return this;
    }

    public SingletonBytesRefBuilder appendBytesRefs(byte[] bytes, long bytesRefLengths) {
        ByteArray values = this.blockFactory.bigArrays().newByteArrayWrapper(bytes);
        this.bytesRefArray = new BytesRefArray((LongArray)new ConstantOffsetLongArrayWrapper(bytesRefLengths, this.count + 1), values, (long)this.count, this.blockFactory.bigArrays());
        return this;
    }

    public BlockLoader.Block build() {
        return this.blockFactory.newBytesRefArrayVector(this.bytesRefArray, this.count).asBlock();
    }

    public BlockLoader.Builder appendNull() {
        throw new UnsupportedOperationException();
    }

    public BlockLoader.Builder beginPositionEntry() {
        throw new UnsupportedOperationException();
    }

    public BlockLoader.Builder endPositionEntry() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    static class LongArrayWrapper
    implements LongArray {
        final long[] values;

        LongArrayWrapper(long[] values) {
            this.values = values;
        }

        public long get(long index) {
            return this.values[(int)index];
        }

        public long getAndSet(long index, long value) {
            throw new UnsupportedOperationException();
        }

        public void set(long index, long value) {
            throw new UnsupportedOperationException();
        }

        public long increment(long index, long inc) {
            throw new UnsupportedOperationException();
        }

        public void fill(long fromIndex, long toIndex, long value) {
            throw new UnsupportedOperationException();
        }

        public void fillWith(StreamInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void set(long index, byte[] buf, int offset, int len) {
            throw new UnsupportedOperationException();
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long size() {
            return this.values.length;
        }

        public long ramBytesUsed() {
            return (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)this.values.length * 8L;
        }

        public void close() {
        }
    }

    static final class ConstantOffsetLongArrayWrapper
    implements LongArray {
        private final long offset;
        private final long size;

        ConstantOffsetLongArrayWrapper(long offset, long size) {
            this.offset = offset;
            this.size = size;
        }

        public long get(long index) {
            assert (index >= 0L && index < this.size);
            return index * this.offset;
        }

        public long getAndSet(long index, long value) {
            throw new UnsupportedOperationException();
        }

        public void set(long index, long value) {
            throw new UnsupportedOperationException();
        }

        public long increment(long index, long inc) {
            throw new UnsupportedOperationException();
        }

        public void fill(long fromIndex, long toIndex, long value) {
            throw new UnsupportedOperationException();
        }

        public void fillWith(StreamInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void set(long index, byte[] buf, int offset, int len) {
            throw new UnsupportedOperationException();
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long size() {
            return this.size;
        }

        public long ramBytesUsed() {
            return 16L;
        }

        public void close() {
        }
    }
}

