/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramScratch;
import org.elasticsearch.compute.data.HistogramBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CompressedExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

final class ExponentialHistogramArrayBlock
extends AbstractNonThreadSafeRefCounted
implements ExponentialHistogramBlock {
    private final DoubleBlock minima;
    private final DoubleBlock maxima;
    private final DoubleBlock sums;
    private final DoubleBlock valueCounts;
    private final DoubleBlock zeroThresholds;
    private final BytesRefBlock encodedHistograms;

    ExponentialHistogramArrayBlock(DoubleBlock minima, DoubleBlock maxima, DoubleBlock sums, DoubleBlock valueCounts, DoubleBlock zeroThresholds, BytesRefBlock encodedHistograms) {
        this.minima = minima;
        this.maxima = maxima;
        this.sums = sums;
        this.valueCounts = valueCounts;
        this.zeroThresholds = zeroThresholds;
        this.encodedHistograms = encodedHistograms;
        assert (this.assertInvariants());
    }

    private boolean assertInvariants() {
        for (Block b : this.getSubBlocks()) {
            assert (!b.isReleased());
            assert (!b.doesHaveMultivaluedFields()) : "ExponentialHistogramArrayBlock sub-blocks can't have multi-values but [" + String.valueOf(b) + "] does";
            assert (b.getPositionCount() == this.getPositionCount()) : "ExponentialHistogramArrayBlock sub-blocks must have the same position count but [" + String.valueOf(b) + "] has " + b.getPositionCount() + " instead of " + this.getPositionCount();
            for (int i = 0; i < b.getPositionCount(); ++i) {
                if (this.isNull(i)) {
                    assert (b.isNull(i)) : "ExponentialHistogramArrayBlock sub-block [" + String.valueOf(b) + "] should be null at position " + i + ", but was not";
                    continue;
                }
                if (b == this.sums || b == this.minima || b == this.maxima) {
                    assert (b.isNull(i) == (this.valueCounts.getDouble(this.valueCounts.getFirstValueIndex(i)) == 0.0)) : "ExponentialHistogramArrayBlock sums/minima/maxima sub-block [" + String.valueOf(b) + "] has wrong nullity at position " + i;
                    continue;
                }
                assert (!b.isNull(i)) : "ExponentialHistogramArrayBlock sub-block [" + String.valueOf(b) + "] should be non-null at position " + i + ", but was not";
            }
        }
        return true;
    }

    private List<Block> getSubBlocks() {
        return List.of(this.sums, this.valueCounts, this.zeroThresholds, this.encodedHistograms, this.minima, this.maxima);
    }

    public static EncodedHistogramData encode(ExponentialHistogram histogram) {
        double sum;
        assert (histogram != null);
        ZeroBucket zeroBucket = histogram.zeroBucket();
        BytesStreamOutput encodedBytes = new BytesStreamOutput();
        try {
            CompressedExponentialHistogram.writeHistogramBytes((OutputStream)encodedBytes, (int)histogram.scale(), (BucketIterator)histogram.negativeBuckets().iterator(), (BucketIterator)histogram.positiveBuckets().iterator());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode histogram", e);
        }
        if (histogram.valueCount() == 0L) {
            assert (histogram.sum() == 0.0) : "Empty histogram should have sum 0.0 but was " + histogram.sum();
            sum = Double.NaN;
        } else {
            sum = histogram.sum();
        }
        return new EncodedHistogramData(histogram.valueCount(), sum, histogram.min(), histogram.max(), zeroBucket.zeroThreshold(), encodedBytes.bytes().toBytesRef());
    }

    @Override
    public ExponentialHistogram getExponentialHistogram(int valueIndex, ExponentialHistogramScratch scratch) {
        assert (!this.isNull(valueIndex)) : "tried to get histogram at null position " + valueIndex;
        BytesRef bytes = this.encodedHistograms.getBytesRef(this.encodedHistograms.getFirstValueIndex(valueIndex), scratch.bytesRefScratch);
        double zeroThreshold = this.zeroThresholds.getDouble(this.zeroThresholds.getFirstValueIndex(valueIndex));
        double valueCount = this.valueCounts.getDouble(this.valueCounts.getFirstValueIndex(valueIndex));
        double sum = valueCount == 0.0 ? 0.0 : this.sums.getDouble(this.sums.getFirstValueIndex(valueIndex));
        double min = valueCount == 0.0 ? Double.NaN : this.minima.getDouble(this.minima.getFirstValueIndex(valueIndex));
        double max = valueCount == 0.0 ? Double.NaN : this.maxima.getDouble(this.maxima.getFirstValueIndex(valueIndex));
        try {
            long roundedValueCount = Math.round(valueCount);
            scratch.reusedHistogram.reset(zeroThreshold, roundedValueCount, sum, min, max, bytes);
            return scratch.reusedHistogram;
        }
        catch (IOException e) {
            throw new IllegalStateException("error loading histogram", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExponentialHistogramBlock createConstant(ExponentialHistogram histogram, int positionCount, BlockFactory blockFactory) {
        ExponentialHistogramArrayBlock exponentialHistogramArrayBlock;
        block3: {
            EncodedHistogramData data = ExponentialHistogramArrayBlock.encode(histogram);
            DoubleBlock minBlock = null;
            DoubleBlock maxBlock = null;
            DoubleBlock sumBlock = null;
            DoubleBlock countBlock = null;
            DoubleBlock zeroThresholdBlock = null;
            BytesRefBlock encodedHistogramBlock = null;
            boolean success = false;
            try {
                countBlock = blockFactory.newConstantDoubleBlockWith(data.count, positionCount);
                minBlock = Double.isNaN(data.min) ? (DoubleBlock)blockFactory.newConstantNullBlock(positionCount) : blockFactory.newConstantDoubleBlockWith(data.min, positionCount);
                maxBlock = Double.isNaN(data.max) ? (DoubleBlock)blockFactory.newConstantNullBlock(positionCount) : blockFactory.newConstantDoubleBlockWith(data.max, positionCount);
                sumBlock = Double.isNaN(data.sum) ? (DoubleBlock)blockFactory.newConstantNullBlock(positionCount) : blockFactory.newConstantDoubleBlockWith(data.sum, positionCount);
                zeroThresholdBlock = blockFactory.newConstantDoubleBlockWith(data.zeroThreshold, positionCount);
                encodedHistogramBlock = blockFactory.newConstantBytesRefBlockWith(data.encodedHistogram, positionCount);
                success = true;
                exponentialHistogramArrayBlock = new ExponentialHistogramArrayBlock(minBlock, maxBlock, sumBlock, countBlock, zeroThresholdBlock, encodedHistogramBlock);
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock, zeroThresholdBlock, encodedHistogramBlock});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock, zeroThresholdBlock, encodedHistogramBlock});
        }
        return exponentialHistogramArrayBlock;
    }

    @Override
    public DoubleBlock buildHistogramComponentBlock(HistogramBlock.Component component) {
        assert (!this.doesHaveMultivaluedFields());
        DoubleBlock result = switch (component) {
            default -> throw new MatchException(null, null);
            case HistogramBlock.Component.MIN -> this.minima;
            case HistogramBlock.Component.MAX -> this.maxima;
            case HistogramBlock.Component.SUM -> this.sums;
            case HistogramBlock.Component.COUNT -> this.valueCounts;
        };
        result.incRef();
        return result;
    }

    @Override
    public void serializeExponentialHistogram(int valueIndex, ExponentialHistogramBlock.SerializedOutput out, BytesRef scratch) {
        double valueCount = this.valueCounts.getDouble(this.valueCounts.getFirstValueIndex(valueIndex));
        out.appendDouble(valueCount);
        out.appendDouble(this.zeroThresholds.getDouble(this.zeroThresholds.getFirstValueIndex(valueIndex)));
        if (valueCount > 0.0) {
            out.appendDouble(this.sums.getDouble(this.sums.getFirstValueIndex(valueIndex)));
            out.appendDouble(this.minima.getDouble(this.minima.getFirstValueIndex(valueIndex)));
            out.appendDouble(this.maxima.getDouble(this.maxima.getFirstValueIndex(valueIndex)));
        }
        out.appendBytesRef(this.encodedHistograms.getBytesRef(this.encodedHistograms.getFirstValueIndex(valueIndex), scratch));
    }

    @Override
    protected void closeInternal() {
        Releasables.close(this.getSubBlocks());
    }

    @Override
    public Vector asVector() {
        return null;
    }

    @Override
    public int getTotalValueCount() {
        return this.encodedHistograms.getTotalValueCount();
    }

    @Override
    public int getPositionCount() {
        return this.encodedHistograms.getPositionCount();
    }

    @Override
    public int getFirstValueIndex(int position) {
        return position;
    }

    @Override
    public int getValueCount(int position) {
        return this.isNull(position) ? 0 : 1;
    }

    @Override
    public ElementType elementType() {
        return ElementType.EXPONENTIAL_HISTOGRAM;
    }

    @Override
    public BlockFactory blockFactory() {
        return this.encodedHistograms.blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.getSubBlocks().forEach(Block::allowPassingToDifferentDriver);
    }

    @Override
    public boolean isNull(int position) {
        return this.encodedHistograms.isNull(position);
    }

    @Override
    public boolean mayHaveNulls() {
        return this.encodedHistograms.mayHaveNulls();
    }

    @Override
    public boolean areAllValuesNull() {
        return this.encodedHistograms.areAllValuesNull();
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return false;
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block filter(int ... positions) {
        DoubleBlock filteredMinima = null;
        DoubleBlock filteredMaxima = null;
        DoubleBlock filteredSums = null;
        DoubleBlock filteredValueCounts = null;
        DoubleBlock filteredZeroThresholds = null;
        BytesRefBlock filteredEncodedHistograms = null;
        boolean success = false;
        try {
            filteredMinima = this.minima.filter(positions);
            filteredMaxima = this.maxima.filter(positions);
            filteredSums = this.sums.filter(positions);
            filteredValueCounts = this.valueCounts.filter(positions);
            filteredZeroThresholds = this.zeroThresholds.filter(positions);
            filteredEncodedHistograms = this.encodedHistograms.filter(positions);
            return new ExponentialHistogramArrayBlock(filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredZeroThresholds, filteredEncodedHistograms);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredZeroThresholds, filteredEncodedHistograms});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block keepMask(BooleanVector mask) {
        DoubleBlock filteredMinima = null;
        DoubleBlock filteredMaxima = null;
        DoubleBlock filteredSums = null;
        DoubleBlock filteredValueCounts = null;
        DoubleBlock filteredZeroThresholds = null;
        BytesRefBlock filteredEncodedHistograms = null;
        boolean success = false;
        try {
            filteredMinima = this.minima.keepMask(mask);
            filteredMaxima = this.maxima.keepMask(mask);
            filteredSums = this.sums.keepMask(mask);
            filteredValueCounts = this.valueCounts.keepMask(mask);
            filteredZeroThresholds = this.zeroThresholds.keepMask(mask);
            filteredEncodedHistograms = this.encodedHistograms.keepMask(mask);
            return new ExponentialHistogramArrayBlock(filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredZeroThresholds, filteredEncodedHistograms);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredZeroThresholds, filteredEncodedHistograms});
            throw throwable;
        }
    }

    @Override
    public ReleasableIterator<? extends Block> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("can't lookup values from ExponentialHistogramArrayBlock");
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public Block expand() {
        this.incRef();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExponentialHistogramArrayBlock deepCopy(BlockFactory blockFactory) {
        DoubleBlock copiedMinima = null;
        DoubleBlock copiedMaxima = null;
        DoubleBlock copiedSums = null;
        DoubleBlock copiedValueCounts = null;
        DoubleBlock copiedZeroThresholds = null;
        BytesRefBlock copiedEncodedHistograms = null;
        boolean success = false;
        try {
            copiedMinima = this.minima.deepCopy(blockFactory);
            copiedMaxima = this.maxima.deepCopy(blockFactory);
            copiedSums = this.sums.deepCopy(blockFactory);
            copiedValueCounts = this.valueCounts.deepCopy(blockFactory);
            copiedZeroThresholds = this.zeroThresholds.deepCopy(blockFactory);
            copiedEncodedHistograms = this.encodedHistograms.deepCopy(blockFactory);
            return new ExponentialHistogramArrayBlock(copiedMinima, copiedMaxima, copiedSums, copiedValueCounts, copiedZeroThresholds, copiedEncodedHistograms);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{copiedMinima, copiedMaxima, copiedSums, copiedValueCounts, copiedZeroThresholds, copiedEncodedHistograms});
            throw throwable;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Block.writeTypedBlock(this.minima, out);
        Block.writeTypedBlock(this.maxima, out);
        Block.writeTypedBlock(this.sums, out);
        Block.writeTypedBlock(this.valueCounts, out);
        Block.writeTypedBlock(this.zeroThresholds, out);
        Block.writeTypedBlock(this.encodedHistograms, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExponentialHistogramArrayBlock readFrom(BlockStreamInput in) throws IOException {
        DoubleBlock minima = null;
        DoubleBlock maxima = null;
        DoubleBlock sums = null;
        DoubleBlock valueCounts = null;
        DoubleBlock zeroThresholds = null;
        BytesRefBlock encodedHistograms = null;
        boolean success = false;
        try {
            minima = (DoubleBlock)Block.readTypedBlock(in);
            maxima = (DoubleBlock)Block.readTypedBlock(in);
            sums = (DoubleBlock)Block.readTypedBlock(in);
            valueCounts = (DoubleBlock)Block.readTypedBlock(in);
            zeroThresholds = (DoubleBlock)Block.readTypedBlock(in);
            encodedHistograms = (BytesRefBlock)Block.readTypedBlock(in);
            return new ExponentialHistogramArrayBlock(minima, maxima, sums, valueCounts, zeroThresholds, encodedHistograms);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, zeroThresholds, encodedHistograms});
            throw throwable;
        }
    }

    public long ramBytesUsed() {
        long bytes = 0L;
        for (Block b : this.getSubBlocks()) {
            bytes += b.ramBytesUsed();
        }
        return bytes;
    }

    void copyInto(DoubleBlock.Builder minimaBuilder, DoubleBlock.Builder maximaBuilder, DoubleBlock.Builder sumsBuilder, DoubleBlock.Builder valueCountsBuilder, DoubleBlock.Builder zeroThresholdsBuilder, BytesRefBlock.Builder encodedHistogramsBuilder, int beginInclusive, int endExclusive) {
        minimaBuilder.copyFrom(this.minima, beginInclusive, endExclusive);
        maximaBuilder.copyFrom(this.maxima, beginInclusive, endExclusive);
        sumsBuilder.copyFrom(this.sums, beginInclusive, endExclusive);
        valueCountsBuilder.copyFrom(this.valueCounts, beginInclusive, endExclusive);
        zeroThresholdsBuilder.copyFrom(this.zeroThresholds, beginInclusive, endExclusive);
        encodedHistogramsBuilder.copyFrom(this.encodedHistograms, beginInclusive, endExclusive);
    }

    public boolean equals(Object o) {
        if (o instanceof ExponentialHistogramBlock) {
            ExponentialHistogramBlock block = (ExponentialHistogramBlock)o;
            return ExponentialHistogramBlock.equals(this, block);
        }
        return false;
    }

    boolean equalsAfterTypeCheck(ExponentialHistogramArrayBlock that) {
        return this.minima.equals(that.minima) && this.maxima.equals(that.maxima) && this.sums.equals(that.sums) && this.valueCounts.equals(that.valueCounts) && this.zeroThresholds.equals(that.zeroThresholds) && this.encodedHistograms.equals(that.encodedHistograms);
    }

    public int hashCode() {
        return this.encodedHistograms.hashCode();
    }

    record EncodedHistogramData(double count, double sum, double min, double max, double zeroThreshold, BytesRef encodedHistogram) {
    }
}

