/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class CompositeBlock
extends AbstractNonThreadSafeRefCounted
implements Block {
    private final Block[] blocks;
    private final int positionCount;

    public CompositeBlock(Block[] blocks) {
        if (blocks == null || blocks.length == 0) {
            throw new IllegalArgumentException("must have at least one block; got " + Arrays.toString(blocks));
        }
        this.blocks = blocks;
        this.positionCount = blocks[0].getPositionCount();
        for (Block b : blocks) {
            assert (b.getPositionCount() == this.positionCount) : "expected positionCount=" + this.positionCount + " but was " + String.valueOf(b);
            if (b.getPositionCount() != this.positionCount) {
                assert (false) : "expected positionCount=" + this.positionCount + " but was " + String.valueOf(b);
                throw new IllegalArgumentException("expected positionCount=" + this.positionCount + " but was " + String.valueOf(b));
            }
            if (!b.isReleased()) continue;
            assert (false) : "can't build composite block out of released blocks but [" + String.valueOf(b) + "] was released";
            throw new IllegalArgumentException("can't build composite block out of released blocks but [" + String.valueOf(b) + "] was released");
        }
    }

    @Override
    public Vector asVector() {
        return null;
    }

    public <B extends Block> B getBlock(int blockIndex) {
        Block block = this.blocks[blockIndex];
        return (B)block;
    }

    public Page asPage() {
        return new Page(this.positionCount, this.blocks);
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    @Override
    public boolean mvSortedAscending() {
        return Arrays.stream(this.blocks).allMatch(Block::mvSortedAscending);
    }

    @Override
    public boolean mvDeduplicated() {
        return Arrays.stream(this.blocks).allMatch(Block::mvDeduplicated);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getTotalValueCount() {
        int totalValueCount = 0;
        for (Block b : this.blocks) {
            totalValueCount += b.getTotalValueCount();
        }
        return totalValueCount;
    }

    @Override
    public int getFirstValueIndex(int position) {
        throw new UnsupportedOperationException("Composite block");
    }

    @Override
    public int getValueCount(int position) {
        throw new UnsupportedOperationException("Composite block");
    }

    @Override
    public boolean isNull(int position) {
        for (Block block : this.blocks) {
            if (block.isNull(position)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ElementType elementType() {
        return ElementType.COMPOSITE;
    }

    @Override
    public BlockFactory blockFactory() {
        return this.blocks[0].blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        for (Block block : this.blocks) {
            block.allowPassingToDifferentDriver();
        }
    }

    @Override
    public boolean mayHaveNulls() {
        return Arrays.stream(this.blocks).anyMatch(Block::mayHaveNulls);
    }

    @Override
    public boolean areAllValuesNull() {
        return Arrays.stream(this.blocks).allMatch(Block::areAllValuesNull);
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return Arrays.stream(this.blocks).anyMatch(Block::mayHaveMultivaluedFields);
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        if (!Arrays.stream(this.blocks).anyMatch(Block::mayHaveMultivaluedFields)) {
            return false;
        }
        return Arrays.stream(this.blocks).anyMatch(Block::doesHaveMultivaluedFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeBlock filter(int ... positions) {
        CompositeBlock result = null;
        Releasable[] filteredBlocks = new Block[this.blocks.length];
        try {
            for (int i = 0; i < this.blocks.length; ++i) {
                filteredBlocks[i] = this.blocks[i].filter(positions);
            }
            CompositeBlock compositeBlock = result = new CompositeBlock((Block[])filteredBlocks);
            return compositeBlock;
        }
        finally {
            if (result == null) {
                Releasables.close((Releasable[])filteredBlocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeBlock deepCopy(BlockFactory blockFactory) {
        CompositeBlock result = null;
        Releasable[] copied = new Block[this.blocks.length];
        try {
            for (int i = 0; i < this.blocks.length; ++i) {
                copied[i] = this.blocks[i].deepCopy(blockFactory);
            }
            CompositeBlock compositeBlock = result = new CompositeBlock((Block[])copied);
            return compositeBlock;
        }
        finally {
            if (result == null) {
                Releasables.close((Releasable[])copied);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block keepMask(BooleanVector mask) {
        CompositeBlock result = null;
        Releasable[] masked = new Block[this.blocks.length];
        try {
            for (int i = 0; i < this.blocks.length; ++i) {
                masked[i] = this.blocks[i].keepMask(mask);
            }
            CompositeBlock compositeBlock = result = new CompositeBlock((Block[])masked);
            return compositeBlock;
        }
        finally {
            if (result == null) {
                Releasables.close((Releasable[])masked);
            }
        }
    }

    @Override
    public ReleasableIterator<? extends Block> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("can't lookup values from CompositeBlock");
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public CompositeBlock expand() {
        throw new UnsupportedOperationException("CompositeBlock");
    }

    public long ramBytesUsed() {
        return Arrays.stream(this.blocks).mapToLong(Accountable::ramBytesUsed).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Block readFrom(StreamInput in) throws IOException {
        int numBlocks = in.readVInt();
        boolean success = false;
        Releasable[] blocks = new Block[numBlocks];
        BlockStreamInput blockStreamInput = (BlockStreamInput)in;
        try {
            for (int b = 0; b < numBlocks; ++b) {
                blocks[b] = Block.readTypedBlock(blockStreamInput);
            }
            CompositeBlock result = new CompositeBlock((Block[])blocks);
            success = true;
            CompositeBlock compositeBlock = result;
            return compositeBlock;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.blocks.length);
        for (Block block : this.blocks) {
            Block.writeTypedBlock(block, out);
        }
    }

    @Override
    protected void closeInternal() {
        Releasables.close((Releasable[])this.blocks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeBlock that = (CompositeBlock)o;
        return this.positionCount == that.positionCount && Objects.deepEquals(this.blocks, that.blocks);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.blocks), this.positionCount);
    }
}

