/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanArrayVector;
import org.elasticsearch.compute.data.BooleanBigArrayVector;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVectorBuilder;
import org.elasticsearch.compute.data.BooleanVectorFixedBuilder;
import org.elasticsearch.compute.data.ConstantBooleanVector;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.ReleasableIterator;

public sealed interface BooleanVector
extends Vector
permits ConstantBooleanVector, BooleanArrayVector, BooleanBigArrayVector, ConstantNullVector {
    public boolean getBoolean(int var1);

    @Override
    public BooleanBlock asBlock();

    @Override
    public BooleanVector filter(int ... var1);

    @Override
    public BooleanBlock keepMask(BooleanVector var1);

    @Override
    default public BooleanVector deepCopy(BlockFactory blockFactory) {
        try (BooleanBlock.Builder builder = blockFactory.newBooleanBlockBuilder(this.getPositionCount());){
            builder.copyFrom(this.asBlock(), 0, this.getPositionCount());
            builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
            BooleanVector booleanVector = builder.build().asVector();
            return booleanVector;
        }
    }

    public ReleasableIterator<? extends BooleanBlock> lookup(IntBlock var1, ByteSizeValue var2);

    public boolean allTrue();

    public boolean allFalse();

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(BooleanVector vector1, BooleanVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getBoolean(pos) == vector2.getBoolean(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(BooleanVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + Boolean.hashCode(vector.getBoolean(pos));
        }
        return result;
    }

    public static BooleanVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> BooleanVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantBooleanVector(in.readBoolean(), positions);
            case 2 -> BooleanArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> BooleanBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeBoolean(this.getBoolean(0));
        } else {
            BooleanVector booleanVector = this;
            if (booleanVector instanceof BooleanArrayVector) {
                BooleanArrayVector v = (BooleanArrayVector)booleanVector;
                out.writeByte((byte)2);
                v.writeArrayVector(positions, out);
            } else {
                booleanVector = this;
                if (booleanVector instanceof BooleanBigArrayVector) {
                    BooleanBigArrayVector v = (BooleanBigArrayVector)booleanVector;
                    out.writeByte((byte)3);
                    v.writeArrayVector(positions, out);
                } else {
                    out.writeByte((byte)0);
                    BooleanVector.writeValues(this, positions, out);
                }
            }
        }
    }

    private static BooleanVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newBooleanVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendBoolean(i, in.readBoolean());
            }
            BooleanVector booleanVector = builder.build();
            return booleanVector;
        }
    }

    private static void writeValues(BooleanVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeBoolean(v.getBoolean(i));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static sealed interface FixedBuilder
    extends Builder
    permits BooleanVectorFixedBuilder {
        @Override
        public FixedBuilder appendBoolean(boolean var1);

        public FixedBuilder appendBoolean(int var1, boolean var2);
    }

    public static sealed interface Builder
    extends Vector.Builder
    permits BooleanVectorBuilder, FixedBuilder {
        public Builder appendBoolean(boolean var1);

        @Override
        public BooleanVector build();
    }
}

