/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.time.Duration;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.TimeSeriesGroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public record WindowGroupingAggregatorFunction(GroupingAggregatorFunction next, AggregatorFunctionSupplier supplier, Duration window) implements GroupingAggregatorFunction
{
    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        return this.next.prepareProcessRawInputPage(seenGroupIds, page);
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.next.selectedMayContainUnseenGroups(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groupIdVector, Page page) {
        this.next.addIntermediateInput(positionOffset, groupIdVector, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groupIdVector, Page page) {
        this.next.addIntermediateInput(positionOffset, groupIdVector, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groupIdVector, Page page) {
        this.next.addIntermediateInput(positionOffset, groupIdVector, page);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.next.evaluateIntermediate(blocks, offset, selected);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evaluationContext) {
        if (evaluationContext instanceof TimeSeriesGroupingAggregatorEvaluationContext) {
            TimeSeriesGroupingAggregatorEvaluationContext timeSeriesContext = (TimeSeriesGroupingAggregatorEvaluationContext)evaluationContext;
            this.evaluateFinalWithWindow(blocks, offset, selected, timeSeriesContext);
        } else {
            this.next.evaluateFinal(blocks, offset, selected, evaluationContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateFinalWithWindow(Block[] blocks, int offset, IntVector selected, final TimeSeriesGroupingAggregatorEvaluationContext evaluationContext) {
        if (selected.getPositionCount() > 0) {
            int groupId = selected.getInt(0);
            long startTime = evaluationContext.rangeStartInMillis(groupId);
            long endTime = evaluationContext.rangeEndInMillis(groupId);
            if (endTime - startTime == this.window.toMillis()) {
                this.next.evaluateFinal(blocks, offset, selected, evaluationContext);
                return;
            }
        }
        int blockCount = this.next.intermediateBlockCount();
        List<Integer> channels = IntStream.range(0, blockCount).boxed().toList();
        GroupingAggregator.Factory aggregatorFactory = this.supplier.groupingAggregatorFactory(AggregatorMode.FINAL, channels);
        try (GroupingAggregator finalAgg = (GroupingAggregator)aggregatorFactory.apply(evaluationContext.driverContext());){
            Releasable[] intermediateBlocks = new Block[blockCount];
            int[] backwards = new int[selected.getPositionCount()];
            int i = 0;
            while (i < selected.getPositionCount()) {
                int groupId = selected.getInt(i);
                backwards = ArrayUtil.grow((int[])backwards, (int)(groupId + 1));
                backwards[groupId] = i++;
            }
            try {
                this.next.evaluateIntermediate((Block[])intermediateBlocks, 0, selected);
                Page page = new Page((Block[])intermediateBlocks);
                finalAgg.aggregatorFunction().addIntermediateInput(0, selected, page);
                for (int i2 = 0; i2 < selected.getPositionCount(); ++i2) {
                    int groupId = selected.getInt(i2);
                    this.mergeBucketsFromWindow(groupId, backwards, page, finalAgg.aggregatorFunction(), evaluationContext);
                }
            }
            finally {
                Releasables.close((Releasable[])intermediateBlocks);
            }
            finalAgg.evaluate(blocks, offset, selected, new TimeSeriesGroupingAggregatorEvaluationContext(evaluationContext.driverContext()){

                @Override
                public long rangeStartInMillis(int groupId) {
                    return evaluationContext.rangeStartInMillis(groupId);
                }

                @Override
                public long rangeEndInMillis(int groupId) {
                    return this.rangeStartInMillis(groupId) + WindowGroupingAggregatorFunction.this.window.toMillis();
                }

                @Override
                public List<Integer> groupIdsFromWindow(int startingGroupId, Duration window) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int previousGroupId(int currentGroupId) {
                    return -1;
                }

                @Override
                public int nextGroupId(int currentGroupId) {
                    return -1;
                }
            });
        }
    }

    private void mergeBucketsFromWindow(int startingGroupId, int[] groupIdToPositions, Page page, GroupingAggregatorFunction fn, TimeSeriesGroupingAggregatorEvaluationContext context) {
        List<Integer> groupIds = context.groupIdsFromWindow(startingGroupId, this.window);
        if (groupIds.size() > 1) {
            try (IntVector oneGroup = context.driverContext().blockFactory().newConstantIntVector(startingGroupId, 1);){
                for (int g : groupIds) {
                    if (g == startingGroupId) continue;
                    int position = groupIdToPositions[g];
                    fn.addIntermediateInput(position, oneGroup, page);
                }
            }
        }
    }

    @Override
    public int intermediateBlockCount() {
        return this.next.intermediateBlockCount();
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.next);
    }

    @Override
    public String toString() {
        return "Window[agg=" + String.valueOf(this.next) + ", window=" + String.valueOf(this.window) + "]";
    }
}

