/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopIpAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIpGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIpAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopIpAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopIpAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopIpGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopIpAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIpAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopIpGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIpGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of ips";
    }
}

