/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopDoubleFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopDoubleFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopDoubleFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopDoubleFloatAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopDoubleFloatAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopDoubleFloatGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopDoubleFloatAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleFloatAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopDoubleFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleFloatGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_double of floats";
    }
}

