/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.VarianceStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;

public class StdDevFloatAggregator {
    public static VarianceStates.SingleState initSingle(boolean stdDev) {
        return new VarianceStates.SingleState(stdDev);
    }

    public static void combine(VarianceStates.SingleState state, float value) {
        state.add(value);
    }

    public static void combineIntermediate(VarianceStates.SingleState state, double mean, double m2, long count) {
        state.combine(mean, m2, count);
    }

    public static Block evaluateFinal(VarianceStates.SingleState state, DriverContext driverContext) {
        return state.evaluateFinal(driverContext);
    }

    public static VarianceStates.GroupingState initGrouping(BigArrays bigArrays, boolean stdDev) {
        return new VarianceStates.GroupingState(bigArrays, stdDev);
    }

    public static void combine(VarianceStates.GroupingState current, int groupId, float value) {
        current.add(groupId, value);
    }

    public static void combineIntermediate(VarianceStates.GroupingState state, int groupId, double mean, double m2, long count) {
        state.combine(groupId, mean, m2, count);
    }

    public static Block evaluateFinal(VarianceStates.GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateFinal(selected, ctx.driverContext());
    }
}

