/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SampleLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.SampleLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class SampleLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;

    public SampleLongAggregatorFunctionSupplier(int limit) {
        this.limit = limit;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return SampleLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return SampleLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public SampleLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return SampleLongAggregatorFunction.create(driverContext, channels, this.limit);
    }

    @Override
    public SampleLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return SampleLongGroupingAggregatorFunction.create(channels, driverContext, this.limit);
    }

    @Override
    public String describe() {
        return "sample of longs";
    }
}

