/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SampleIntAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SampleIntGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("sample", ElementType.BYTES_REF));
    private final SampleIntAggregator.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final int limit;

    public SampleIntGroupingAggregatorFunction(List<Integer> channels, SampleIntAggregator.GroupingState state, DriverContext driverContext, int limit) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.limit = limit;
    }

    public static SampleIntGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, int limit) {
        return new SampleIntGroupingAggregatorFunction(channels, SampleIntAggregator.initGrouping(driverContext.bigArrays(), limit), driverContext, limit);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        final IntVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    SampleIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    SampleIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SampleIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                SampleIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                SampleIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SampleIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, IntBlock valueBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    int valueValue = valueBlock.getInt(valueOffset);
                    SampleIntAggregator.combine(this.state, groupId, valueValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, IntVector valueVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueValue = valueVector.getInt(valuesPosition);
                SampleIntAggregator.combine(this.state, groupId, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        BytesRef sampleScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SampleIntAggregator.combineIntermediate(this.state, groupId, sample, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, IntBlock valueBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    int valueValue = valueBlock.getInt(valueOffset);
                    SampleIntAggregator.combine(this.state, groupId, valueValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, IntVector valueVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueValue = valueVector.getInt(valuesPosition);
                SampleIntAggregator.combine(this.state, groupId, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        BytesRef sampleScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SampleIntAggregator.combineIntermediate(this.state, groupId, sample, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntBlock valueBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (valueBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
            int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                int valueValue = valueBlock.getInt(valueOffset);
                SampleIntAggregator.combine(this.state, groupId, valueValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntVector valueVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            int valueValue = valueVector.getInt(valuesPosition);
            SampleIntAggregator.combine(this.state, groupId, valueValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        BytesRef sampleScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            SampleIntAggregator.combineIntermediate(this.state, groupId, sample, valuesPosition);
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, IntBlock valueBlock) {
        if (valueBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = SampleIntAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

