/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AbstractRateGroupingFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.TimeSeriesGroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class RateIntGroupingAggregatorFunction
extends AbstractRateGroupingFunction
implements GroupingAggregatorFunction {
    static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.INT), new IntermediateStateDesc("sampleCounts", ElementType.LONG), new IntermediateStateDesc("resets", ElementType.DOUBLE));
    private final IntRawBuffer rawBuffer;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final BigArrays bigArrays;
    private ObjectArray<ReducedState> reducedStates;
    private final boolean isRateOverTime;
    private final double dateFactor;
    private int lastSliceIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateIntGroupingAggregatorFunction(List<Integer> channels, DriverContext driverContext, boolean isRateOverTime, boolean isDateNanos) {
        this.channels = channels;
        this.driverContext = driverContext;
        this.bigArrays = driverContext.bigArrays();
        this.isRateOverTime = isRateOverTime;
        this.dateFactor = isDateNanos ? 1.0E9 : 1000.0;
        boolean success = false;
        try {
            this.rawBuffer = new IntRawBuffer(this.bigArrays);
            this.reducedStates = driverContext.bigArrays().newObjectArray(256L);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final IntBlock valuesBlock = (IntBlock)page.getBlock(this.channels.get(0));
        if (valuesBlock.areAllValuesNull()) {
            return new GroupingAggregatorFunction.AddInput(this){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                }

                public void close() {
                }
            };
        }
        LongBlock timestampsBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final LongVector timestampsVector = timestampsBlock.asVector();
        if (timestampsVector == null) {
            assert (false) : "expected timestamp vector in time-series aggregation";
            throw new IllegalStateException("expected timestamp vector in time-series aggregation");
        }
        IntVector sliceIndices = ((IntBlock)page.getBlock(this.channels.get(2))).asVector();
        assert (sliceIndices != null) : "expected slice indices vector in time-series aggregation";
        LongVector futureMaxTimestamps = ((LongBlock)page.getBlock(this.channels.get(3))).asVector();
        assert (futureMaxTimestamps != null) : "expected future max timestamps vector in time-series aggregation";
        int sliceIndex = sliceIndices.getInt(0);
        if (sliceIndex > this.lastSliceIndex) {
            this.flushRawBuffers();
            this.lastSliceIndex = sliceIndex;
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                IntVector valuesVector = valuesBlock.asVector();
                if (valuesVector != null) {
                    RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
                } else {
                    RateIntGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntBlock groups, IntBlock valueBlock, LongVector timestampVector) {
        int lastGroup = -1;
        int positionCount = groups.getPositionCount();
        for (int p = 0; p < positionCount; ++p) {
            int valuePosition;
            if (groups.isNull(p) || valueBlock.isNull(valuePosition = p + positionOffset)) continue;
            assert (valueBlock.getValueCount(valuePosition) == 1) : "expected single-valued block " + String.valueOf(valueBlock);
            int groupStart = groups.getFirstValueIndex(p);
            int groupEnd = groupStart + groups.getValueCount(p);
            long timestamp = timestampVector.getLong(valuePosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int value = valueBlock.getInt(valueBlock.getFirstValueIndex(valuePosition));
                if (lastGroup != groupId) {
                    this.rawBuffer.prepareForAppend(groupId, 1, timestamp);
                    this.rawBuffer.appendWithoutResize(timestamp, value);
                    lastGroup = groupId;
                    continue;
                }
                this.rawBuffer.maybeResizeAndAppend(timestamp, value);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntBlock valueBlock, LongVector timestampVector) {
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            this.addSubRange(groupId, positionOffset, positionOffset + positionCount, valueBlock, timestampVector);
        } else {
            int lastGroup = groups.getInt(0);
            int lastPosition = 0;
            for (int p = 1; p < positionCount; ++p) {
                int group = groups.getInt(p);
                if (group == lastGroup) continue;
                this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + p, valueBlock, timestampVector);
                lastGroup = group;
                lastPosition = p;
            }
            this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + positionCount, valueBlock, timestampVector);
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntVector valueVector, LongVector timestampVector) {
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            this.addSubRange(groupId, positionOffset, positionOffset + positionCount, valueVector, timestampVector);
        } else {
            int lastGroup = groups.getInt(0);
            int lastPosition = 0;
            for (int p = 1; p < positionCount; ++p) {
                int group = groups.getInt(p);
                if (group == lastGroup) continue;
                this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + p, valueVector, timestampVector);
                lastGroup = group;
                lastPosition = p;
            }
            this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + positionCount, valueVector, timestampVector);
        }
    }

    private void addSubRange(int group, int from, int to, IntVector valueVector, LongVector timestampVector) {
        this.rawBuffer.prepareForAppend(group, to - from, timestampVector.getLong(from));
        this.rawBuffer.appendRange(from, to, valueVector, timestampVector);
    }

    private void addSubRange(int group, int from, int to, IntBlock valueBlock, LongVector timestampVector) {
        this.rawBuffer.prepareForAppend(group, to - from, timestampVector.getLong(from));
        this.rawBuffer.appendRange(from, to, valueBlock, timestampVector);
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.addIntermediateInputBlock(positionOffset, groups, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.addIntermediateInputBlock(positionOffset, groups, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        LongBlock timestamps = (LongBlock)page.getBlock(this.channels.get(0));
        IntBlock values = (IntBlock)page.getBlock(this.channels.get(1));
        assert (timestamps.getTotalValueCount() == values.getTotalValueCount()) : "timestamps=" + String.valueOf(timestamps) + "; values=" + String.valueOf(values);
        if (values.areAllValuesNull()) {
            return;
        }
        LongVector sampleCounts = ((LongBlock)page.getBlock(this.channels.get(2))).asVector();
        DoubleVector resets = ((DoubleBlock)page.getBlock(this.channels.get(3))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuePosition = positionOffset + groupPosition;
            long sampleCount = sampleCounts.getLong(valuePosition);
            if (sampleCount == 0L) continue;
            int groupId = groups.getInt(groupPosition);
            this.reducedStates = this.bigArrays.grow(this.reducedStates, (long)(groupId + 1));
            ReducedState state = (ReducedState)this.reducedStates.get((long)groupId);
            if (state == null) {
                state = new ReducedState();
                this.reducedStates.set((long)groupId, (Object)state);
            }
            state.appendIntervalsFromBlocks(timestamps, values, valuePosition);
            state.samples += sampleCount;
            state.resets += resets.getDouble(valuePosition);
        }
    }

    private void addIntermediateInputBlock(int positionOffset, IntBlock groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        LongBlock timestamps = (LongBlock)page.getBlock(this.channels.get(0));
        IntBlock values = (IntBlock)page.getBlock(this.channels.get(1));
        assert (timestamps.getTotalValueCount() == values.getTotalValueCount()) : "timestamps=" + String.valueOf(timestamps) + "; values=" + String.valueOf(values);
        if (values.areAllValuesNull()) {
            return;
        }
        LongVector sampleCounts = ((LongBlock)page.getBlock(this.channels.get(2))).asVector();
        DoubleVector resets = ((DoubleBlock)page.getBlock(this.channels.get(3))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuePosition = positionOffset + groupPosition;
            long sampleCount = sampleCounts.getLong(valuePosition);
            if (sampleCount == 0L || groups.isNull(groupPosition)) continue;
            int firstGroup = groups.getFirstValueIndex(groupPosition);
            int lastGroup = firstGroup + groups.getValueCount(groupPosition);
            for (int g = firstGroup; g < lastGroup; ++g) {
                int groupId = groups.getInt(g);
                this.reducedStates = this.bigArrays.grow(this.reducedStates, (long)(groupId + 1));
                ReducedState state = (ReducedState)this.reducedStates.get((long)groupId);
                if (state == null) {
                    state = new ReducedState();
                    this.reducedStates.set((long)groupId, (Object)state);
                }
                state.appendIntervalsFromBlocks(timestamps, values, valuePosition);
                state.samples += sampleCount;
                state.resets += resets.getDouble(valuePosition);
            }
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        BlockFactory blockFactory = this.driverContext.blockFactory();
        int positionCount = selected.getPositionCount();
        try (AbstractRateGroupingFunction.FlushQueues flushQueues = this.rawBuffer.prepareForFlush();
             LongBlock.Builder timestamps = blockFactory.newLongBlockBuilder(positionCount * 2);
             IntBlock.Builder values = blockFactory.newIntBlockBuilder(positionCount * 2);
             LongVector.FixedBuilder sampleCounts = blockFactory.newLongVectorFixedBuilder(positionCount);
             DoubleVector.FixedBuilder resets = blockFactory.newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int group = selected.getInt(p);
                ReducedState state = this.flushAndCombineState(flushQueues, group);
                if (state != null && state.samples > 0L) {
                    timestamps.beginPositionEntry();
                    values.beginPositionEntry();
                    for (Interval interval : state.intervals) {
                        timestamps.appendLong(interval.t1);
                        timestamps.appendLong(interval.t2);
                        values.appendInt(interval.v1);
                        values.appendInt(interval.v2);
                    }
                    timestamps.endPositionEntry();
                    values.endPositionEntry();
                    sampleCounts.appendLong(state.samples);
                    resets.appendDouble(state.resets);
                    continue;
                }
                timestamps.appendLong(0L);
                values.appendInt(0);
                sampleCounts.appendLong(0L);
                resets.appendDouble(0.0);
            }
            blocks[offset] = timestamps.build();
            blocks[offset + 1] = values.build();
            blocks[offset + 2] = sampleCounts.build().asBlock();
            blocks[offset + 3] = resets.build().asBlock();
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.reducedStates, this.rawBuffer});
    }

    void flushRawBuffers() {
        if (this.rawBuffer.minGroupId > this.rawBuffer.maxGroupId) {
            return;
        }
        this.reducedStates = this.bigArrays.grow(this.reducedStates, (long)(this.rawBuffer.maxGroupId + 1));
        try (AbstractRateGroupingFunction.FlushQueues flushQueues = this.rawBuffer.prepareForFlush();){
            for (int groupId = this.rawBuffer.minGroupId; groupId <= this.rawBuffer.maxGroupId; ++groupId) {
                AbstractRateGroupingFunction.FlushQueue flushQueue = flushQueues.getFlushQueue(groupId);
                if (flushQueue == null) continue;
                ReducedState state = (ReducedState)this.reducedStates.get((long)groupId);
                if (state == null) {
                    state = new ReducedState();
                    this.reducedStates.set((long)groupId, (Object)state);
                }
                RateIntGroupingAggregatorFunction.flushGroup(state, this.rawBuffer, flushQueue);
            }
        }
        this.rawBuffer.minGroupId = Integer.MAX_VALUE;
        this.rawBuffer.maxGroupId = Integer.MIN_VALUE;
    }

    static void flushGroup(ReducedState state, IntRawBuffer buffer, AbstractRateGroupingFunction.FlushQueue flushQueue) {
        int val;
        int p;
        LongArray timestamps = buffer.timestamps;
        IntArray values = buffer.values;
        if (flushQueue.valueCount == 1) {
            ++state.samples;
            long t = timestamps.get((long)((AbstractRateGroupingFunction.Slice)flushQueue.top()).start);
            int v = values.get((long)((AbstractRateGroupingFunction.Slice)flushQueue.top()).start);
            state.appendInterval(new Interval(t, v, t, v));
            return;
        }
        AbstractRateGroupingFunction.Slice top = (AbstractRateGroupingFunction.Slice)flushQueue.top();
        int position = top.next();
        long lastTimestamp = timestamps.get((long)position);
        int lastValue = values.get((long)position);
        if (top.exhausted()) {
            flushQueue.pop();
            top = (AbstractRateGroupingFunction.Slice)flushQueue.top();
        } else {
            top = (AbstractRateGroupingFunction.Slice)flushQueue.updateTop();
        }
        int prevValue = lastValue;
        long secondNextTimestamp = flushQueue.secondNextTimestamp();
        while (flushQueue.size() > 1) {
            if (top.lastTimestamp() > secondNextTimestamp) {
                for (p = top.start; p < top.end; ++p) {
                    val = values.get((long)p);
                    if (val > prevValue) {
                        state.resets += (double)val;
                    }
                    prevValue = val;
                }
                flushQueue.pop();
                top = (AbstractRateGroupingFunction.Slice)flushQueue.top();
                secondNextTimestamp = flushQueue.secondNextTimestamp();
                continue;
            }
            int val2 = values.get((long)top.next());
            if (val2 > prevValue) {
                state.resets += (double)val2;
            }
            prevValue = val2;
            if (top.exhausted()) {
                flushQueue.pop();
                top = (AbstractRateGroupingFunction.Slice)flushQueue.top();
                secondNextTimestamp = flushQueue.secondNextTimestamp();
                continue;
            }
            if (top.nextTimestamp >= secondNextTimestamp) continue;
            top = (AbstractRateGroupingFunction.Slice)flushQueue.updateTop();
            secondNextTimestamp = flushQueue.secondNextTimestamp();
        }
        top = (AbstractRateGroupingFunction.Slice)flushQueue.top();
        for (p = top.start; p < top.end; ++p) {
            val = values.get((long)p);
            if (val > prevValue) {
                state.resets += (double)val;
            }
            prevValue = val;
        }
        state.samples += (long)flushQueue.valueCount;
        state.appendInterval(new Interval(lastTimestamp, lastValue, timestamps.get((long)(top.end - 1)), prevValue));
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        BlockFactory blockFactory = this.driverContext.blockFactory();
        int positionCount = selected.getPositionCount();
        try (AbstractRateGroupingFunction.FlushQueues flushQueues = this.rawBuffer.prepareForFlush();
             DoubleBlock.Builder rates = blockFactory.newDoubleBlockBuilder(positionCount);
             LongObjectPagedHashMap flushedStates = new LongObjectPagedHashMap((long)positionCount, this.bigArrays);){
            ReducedState state;
            int group;
            int p;
            for (p = 0; p < positionCount; ++p) {
                group = selected.getInt(p);
                state = this.flushAndCombineState(flushQueues, group);
                if (state == null) continue;
                flushedStates.put((long)group, (Object)state);
                Comparable[] intervals = state.intervals;
                ArrayUtil.timSort((Comparable[])intervals);
                for (int i = 1; i < intervals.length; ++i) {
                    Comparable next = intervals[i - 1];
                    Comparable prev = intervals[i];
                    if (((Interval)prev).v1 <= ((Interval)next).v2) continue;
                    state.resets += (double)((Interval)prev).v1;
                }
            }
            for (p = 0; p < positionCount; ++p) {
                double rate;
                group = selected.getInt(p);
                state = (ReducedState)flushedStates.get((long)group);
                if (state == null || state.samples == 0L) {
                    rate = Double.NaN;
                } else if (evalContext instanceof TimeSeriesGroupingAggregatorEvaluationContext) {
                    TimeSeriesGroupingAggregatorEvaluationContext tsContext = (TimeSeriesGroupingAggregatorEvaluationContext)evalContext;
                    rate = RateIntGroupingAggregatorFunction.computeRate((LongObjectPagedHashMap<ReducedState>)flushedStates, group, tsContext, this.isRateOverTime, this.dateFactor);
                } else {
                    rate = RateIntGroupingAggregatorFunction.computeRateWithoutExtrapolate(state, this.isRateOverTime, this.dateFactor);
                }
                if (Double.isNaN(rate)) {
                    rates.appendNull();
                    continue;
                }
                rates.appendDouble(rate);
            }
            blocks[offset] = rates.build();
        }
    }

    ReducedState flushAndCombineState(AbstractRateGroupingFunction.FlushQueues flushQueues, int groupId) {
        ReducedState state = (long)groupId < this.reducedStates.size() ? (ReducedState)this.reducedStates.getAndSet((long)groupId, null) : null;
        AbstractRateGroupingFunction.FlushQueue flushQueue = flushQueues.getFlushQueue(groupId);
        if (flushQueue != null) {
            if (state == null) {
                state = new ReducedState();
            }
            RateIntGroupingAggregatorFunction.flushGroup(state, this.rawBuffer, flushQueue);
        }
        return state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    private static double computeRateWithoutExtrapolate(ReducedState state, boolean isRateOverTime, double dateFactor) {
        if (state.samples < 2L) {
            return Double.NaN;
        }
        long firstTS = state.intervals[state.intervals.length - 1].t2;
        long lastTS = state.intervals[0].t1;
        double firstValue = state.intervals[state.intervals.length - 1].v2;
        double lastValue = (double)state.intervals[0].v1 + state.resets;
        if (isRateOverTime) {
            return (lastValue - firstValue) * dateFactor / (double)(lastTS - firstTS);
        }
        return lastValue - firstValue;
    }

    private static double computeRate(LongObjectPagedHashMap<ReducedState> states, int group, TimeSeriesGroupingAggregatorEvaluationContext tsContext, boolean isRateOverTime, double dateFactor) {
        double lastValue;
        ReducedState nextState;
        double firstValue;
        ReducedState previousState;
        ReducedState state = (ReducedState)states.get((long)group);
        double tbucketStart = (double)tsContext.rangeStartInMillis(group) / 1000.0;
        double tbucketEnd = (double)tsContext.rangeEndInMillis(group) / 1000.0;
        double firstTsSec = tbucketStart;
        double lastTsSec = tbucketEnd;
        int previousGroupId = tsContext.previousGroupId(group);
        ReducedState reducedState = previousState = previousGroupId >= 0 ? (ReducedState)states.get((long)previousGroupId) : null;
        if (previousState == null || previousState.samples == 0L) {
            if (state.samples == 1L) {
                firstTsSec = (double)state.intervals[0].t1 / dateFactor;
                firstValue = state.intervals[0].v1;
            } else {
                firstValue = RateIntGroupingAggregatorFunction.extrapolateToBoundary(state, tbucketStart, tbucketEnd, dateFactor, true);
            }
        } else {
            firstValue = RateIntGroupingAggregatorFunction.interpolateBetweenStates(previousState, state, tbucketStart, tbucketEnd, dateFactor, true);
        }
        int nextGroupId = tsContext.nextGroupId(group);
        ReducedState reducedState2 = nextState = nextGroupId >= 0 ? (ReducedState)states.get((long)nextGroupId) : null;
        if (nextState == null || nextState.samples == 0L) {
            if (state.samples == 1L) {
                lastTsSec = (double)state.intervals[0].t1 / dateFactor;
                lastValue = state.intervals[0].v1;
            } else {
                lastValue = RateIntGroupingAggregatorFunction.extrapolateToBoundary(state, tbucketStart, tbucketEnd, dateFactor, false);
            }
        } else {
            lastValue = RateIntGroupingAggregatorFunction.interpolateBetweenStates(state, nextState, tbucketStart, tbucketEnd, dateFactor, false) + state.resets;
        }
        if (lastTsSec == firstTsSec) {
            if (state.samples == 1L) {
                if (previousState != null) {
                    assert (nextState == null);
                    assert ((double)state.intervals[0].t1 == firstTsSec * dateFactor) : firstTsSec + ":" + state.intervals[0].t1;
                    double startTs = (double)previousState.intervals[0].t1 / dateFactor;
                    double delta = RateIntGroupingAggregatorFunction.deltaBetweenStates(previousState, state, dateFactor);
                    return isRateOverTime ? delta / (firstTsSec - startTs) : delta;
                }
                if (nextState != null) {
                    assert ((double)state.intervals[0].t1 == lastTsSec * dateFactor) : lastTsSec + ":" + state.intervals[0].t1;
                    double endTs = (double)nextState.intervals[nextState.intervals.length - 1].t2 / dateFactor;
                    double delta = RateIntGroupingAggregatorFunction.deltaBetweenStates(state, nextState, dateFactor);
                    return isRateOverTime ? delta / (endTs - lastTsSec) : delta;
                }
            }
            return Double.NaN;
        }
        double increase = lastValue - firstValue;
        assert (increase >= 0.0) : "increase must be non-negative, got " + lastValue + " - " + firstValue;
        return isRateOverTime ? increase / (lastTsSec - firstTsSec) : increase;
    }

    private static double extrapolateToBoundary(ReducedState state, double tbucketStart, double tbucketEnd, double dateFactor, boolean isLowerBoundary) {
        double startTs = (double)state.intervals[state.intervals.length - 1].t2 / dateFactor;
        double startValue = state.intervals[state.intervals.length - 1].v2;
        double endTs = (double)state.intervals[0].t1 / dateFactor;
        double endValue = (double)state.intervals[0].v1 + state.resets;
        double sampleTsSec = endTs - startTs;
        double averageSampleInterval = sampleTsSec / (double)state.samples;
        double slope = (endValue - startValue) / sampleTsSec;
        if (isLowerBoundary) {
            double startGapSec = startTs - tbucketStart;
            if (startGapSec > 0.0) {
                if (startGapSec > averageSampleInterval * 1.1) {
                    startGapSec = averageSampleInterval / 2.0;
                }
                return Math.max(0.0, startValue - startGapSec * slope);
            }
            return startValue;
        }
        double endGapSec = tbucketEnd - endTs;
        if (endGapSec > 0.0) {
            if (endGapSec > averageSampleInterval * 1.1) {
                endGapSec = averageSampleInterval / 2.0;
            }
            return endValue + endGapSec * slope;
        }
        return endValue;
    }

    private static double interpolateBetweenStates(ReducedState lowerState, ReducedState upperState, double tbucketStart, double tbucketEnd, double dateFactor, boolean isLowerBoundary) {
        double startValue = lowerState.intervals[0].v1;
        double startTs = (double)lowerState.intervals[0].t1 / dateFactor;
        double endValue = upperState.intervals[upperState.intervals.length - 1].v2;
        double endTs = (double)upperState.intervals[upperState.intervals.length - 1].t2 / dateFactor;
        assert (startTs < endTs) : "expected startTs < endTs, got " + startTs + " < " + endTs;
        double delta = RateIntGroupingAggregatorFunction.deltaBetweenStates(lowerState, upperState, dateFactor);
        double slope = delta / (endTs - startTs);
        if (isLowerBoundary) {
            assert (startTs <= tbucketStart) : startTs + " <= " + tbucketStart;
            double baseValue = endValue >= startValue ? startValue : 0.0;
            double timeDelta = tbucketStart - startTs;
            return baseValue + slope * timeDelta;
        }
        assert (startTs <= tbucketEnd) : startTs + " <= " + tbucketEnd;
        double timeDelta = tbucketEnd - startTs;
        return startValue + slope * timeDelta;
    }

    private static double deltaBetweenStates(ReducedState lowerState, ReducedState upperState, double dateFactor) {
        double startValue = lowerState.intervals[0].v1;
        double startTs = (double)lowerState.intervals[0].t1 / dateFactor;
        double endValue = upperState.intervals[upperState.intervals.length - 1].v2;
        double endTs = (double)upperState.intervals[upperState.intervals.length - 1].t2 / dateFactor;
        return endValue >= startValue ? endValue - startValue : endValue;
    }

    static final class IntRawBuffer
    extends AbstractRateGroupingFunction.RawBuffer {
        private IntArray values;

        IntRawBuffer(BigArrays bigArrays) {
            super(bigArrays);
            boolean success = false;
            try {
                this.values = bigArrays.newIntArray(2048L, false);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        void prepareForAppend(int groupId, int count, long firstTimestamp) {
            this.prepareSlicesOnly(groupId, firstTimestamp);
            int newSize = this.valueCount + count;
            this.timestamps = this.bigArrays.grow(this.timestamps, (long)newSize);
            this.values = this.bigArrays.grow(this.values, (long)newSize);
        }

        void appendWithoutResize(long timestamp, int value) {
            this.timestamps.set((long)this.valueCount, timestamp);
            this.values.set((long)this.valueCount, value);
            ++this.valueCount;
        }

        void maybeResizeAndAppend(long timestamp, int value) {
            this.timestamps = this.bigArrays.grow(this.timestamps, (long)(this.valueCount + 1));
            this.values = this.bigArrays.grow(this.values, (long)(this.valueCount + 1));
            this.appendWithoutResize(timestamp, value);
        }

        void appendRange(int fromPosition, int toPosition, IntVector valueVector, LongVector timestampVector) {
            for (int p = fromPosition; p < toPosition; ++p) {
                this.values.set((long)this.valueCount, valueVector.getInt(p));
                this.timestamps.set((long)this.valueCount, timestampVector.getLong(p));
                ++this.valueCount;
            }
        }

        void appendRange(int fromPosition, int toPosition, IntBlock valueBlock, LongVector timestampVector) {
            for (int p = fromPosition; p < toPosition; ++p) {
                if (valueBlock.isNull(p)) continue;
                assert (valueBlock.getValueCount(p) == 1) : "expected single-valued block " + String.valueOf(valueBlock);
                this.values.set((long)this.valueCount, valueBlock.getInt(p));
                this.timestamps.set((long)this.valueCount, timestampVector.getLong(p));
                ++this.valueCount;
            }
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
        }
    }

    static final class ReducedState {
        private static final Interval[] EMPTY_INTERVALS = new Interval[0];
        long samples;
        double resets;
        Interval[] intervals = EMPTY_INTERVALS;

        ReducedState() {
        }

        void appendInterval(Interval interval) {
            int currentSize = this.intervals.length;
            this.intervals = (Interval[])ArrayUtil.growExact((Object[])this.intervals, (int)(currentSize + 1));
            this.intervals[currentSize] = interval;
        }

        void appendIntervalsFromBlocks(LongBlock ts, IntBlock vs, int position) {
            int tsFirst = ts.getFirstValueIndex(position);
            int vsFirst = vs.getFirstValueIndex(position);
            int count = ts.getValueCount(position);
            assert (count % 2 == 0) : "expected even number of values for intervals, got " + count + " in " + String.valueOf(ts);
            int currentSize = this.intervals.length;
            this.intervals = (Interval[])ArrayUtil.growExact((Object[])this.intervals, (int)(currentSize + count / 2));
            for (int i = 0; i < count; i += 2) {
                Interval interval = new Interval(ts.getLong(tsFirst + i), vs.getInt(vsFirst + i), ts.getLong(tsFirst + i + 1), vs.getInt(vsFirst + i + 1));
                this.intervals[currentSize++] = interval;
            }
        }
    }

    record Interval(long t1, int v1, long t2, int v2) implements Comparable<Interval>
    {
        @Override
        public int compareTo(Interval other) {
            return Long.compare(other.t1, this.t1);
        }
    }

    public static final class FunctionSupplier
    implements AggregatorFunctionSupplier {
        private final boolean isRateOverTime;
        private final boolean isDateNanos;

        public FunctionSupplier(boolean isRateOverTime, boolean isDateNanos) {
            this.isRateOverTime = isRateOverTime;
            this.isDateNanos = isDateNanos;
        }

        @Override
        public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
            return INTERMEDIATE_STATE_DESC;
        }

        @Override
        public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public RateIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
            return new RateIntGroupingAggregatorFunction(channels, driverContext, this.isRateOverTime, this.isDateNanos);
        }

        @Override
        public String describe() {
            return "rate of int";
        }
    }
}

