/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.ExponentialHistogramStates;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LastExponentialHistogramByTimestampAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramScratch;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;

public final class LastExponentialHistogramByTimestampAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.EXPONENTIAL_HISTOGRAM), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final ExponentialHistogramStates.WithLongSingleState state;
    private final List<Integer> channels;

    public LastExponentialHistogramByTimestampAggregatorFunction(DriverContext driverContext, List<Integer> channels, ExponentialHistogramStates.WithLongSingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static LastExponentialHistogramByTimestampAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new LastExponentialHistogramByTimestampAggregatorFunction(driverContext, channels, LastExponentialHistogramByTimestampAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        ExponentialHistogramBlock valueBlock = (ExponentialHistogramBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.addRawBlock(valueBlock, timestampBlock, mask);
    }

    private void addRawInputNotMasked(Page page) {
        ExponentialHistogramBlock valueBlock = (ExponentialHistogramBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.addRawBlock(valueBlock, timestampBlock);
    }

    private void addRawBlock(ExponentialHistogramBlock valueBlock, LongBlock timestampBlock) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int timestampValueCount;
            int valueValueCount = valueBlock.getValueCount(p);
            if (valueValueCount == 0 || (timestampValueCount = timestampBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampValueCount;
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    LastExponentialHistogramByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawBlock(ExponentialHistogramBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        ExponentialHistogramScratch valueScratch = new ExponentialHistogramScratch();
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int timestampValueCount;
            int valueValueCount;
            if (!mask.getBoolean(p) || (valueValueCount = valueBlock.getValueCount(p)) == 0 || (timestampValueCount = timestampBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                ExponentialHistogram valueValue = valueBlock.getExponentialHistogram(valueOffset, valueScratch);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampValueCount;
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    LastExponentialHistogramByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + LastExponentialHistogramByTimestampAggregatorFunction.intermediateStateDesc().size());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongVector timestamps = ((LongBlock)timestampsUncast).asVector();
        assert (timestamps.getPositionCount() == 1);
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        ExponentialHistogramBlock values = (ExponentialHistogramBlock)valuesUncast;
        assert (values.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        ExponentialHistogramScratch valuesScratch = new ExponentialHistogramScratch();
        LastExponentialHistogramByTimestampAggregator.combineIntermediate(this.state, timestamps.getLong(0), values.getExponentialHistogram(values.getFirstValueIndex(0), valuesScratch), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = LastExponentialHistogramByTimestampAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

