/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.ExponentialHistogramStates;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;

public class LastExponentialHistogramByTimestampAggregator {
    public static String describe() {
        return "last_ExponentialHistogram_by_timestamp";
    }

    public static ExponentialHistogramStates.WithLongSingleState initSingle(DriverContext driverContext) {
        return new ExponentialHistogramStates.WithLongSingleState(driverContext.breaker());
    }

    public static void combine(ExponentialHistogramStates.WithLongSingleState current, ExponentialHistogram value, long timestamp) {
        if (timestamp > current.longValue()) {
            current.set(timestamp, value);
        }
    }

    public static void combineIntermediate(ExponentialHistogramStates.WithLongSingleState current, long timestamp, ExponentialHistogram value, boolean seen) {
        if (seen) {
            if (current.isSeen()) {
                LastExponentialHistogramByTimestampAggregator.combine(current, value, timestamp);
            } else {
                current.set(timestamp, value);
            }
        }
    }

    public static Block evaluateFinal(ExponentialHistogramStates.WithLongSingleState current, DriverContext ctx) {
        return current.evaluateFinalHistogram(ctx);
    }

    public static ExponentialHistogramStates.WithLongGroupingState initGrouping(DriverContext driverContext) {
        return new ExponentialHistogramStates.WithLongGroupingState(driverContext.bigArrays(), driverContext.breaker());
    }

    public static void combine(ExponentialHistogramStates.WithLongGroupingState current, int groupId, ExponentialHistogram value, long timestamp) {
        if (!current.seen(groupId) || timestamp > current.longValue(groupId)) {
            current.set(groupId, timestamp, value);
        }
    }

    public static void combineIntermediate(ExponentialHistogramStates.WithLongGroupingState current, int groupId, long timestamp, ExponentialHistogram value, boolean seen) {
        if (seen) {
            LastExponentialHistogramByTimestampAggregator.combine(current, groupId, value, timestamp);
        }
    }

    public static Block evaluateFinal(ExponentialHistogramStates.WithLongGroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateFinalHistograms(selected, ctx.driverContext());
    }
}

