/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.FirstIntByTimestampAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LongIntState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class FirstIntByTimestampAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.INT), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final LongIntState state;
    private final List<Integer> channels;

    public FirstIntByTimestampAggregatorFunction(DriverContext driverContext, List<Integer> channels, LongIntState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static FirstIntByTimestampAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new FirstIntByTimestampAggregatorFunction(driverContext, channels, FirstIntByTimestampAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        IntVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        this.addRawVector(valueVector, timestampVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        IntBlock valueBlock = (IntBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        IntVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        this.addRawVector(valueVector, timestampVector);
    }

    private void addRawVector(IntVector valueVector, LongVector timestampVector) {
        long timestampValue;
        int valueValue;
        int valuesPosition = 0;
        if (!this.state.seen() && valuesPosition < valueVector.getPositionCount()) {
            valueValue = valueVector.getInt(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstIntByTimestampAggregator.first(this.state, valueValue, timestampValue);
            ++valuesPosition;
            this.state.seen(true);
        }
        while (valuesPosition < valueVector.getPositionCount()) {
            valueValue = valueVector.getInt(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstIntByTimestampAggregator.combine(this.state, valueValue, timestampValue);
            ++valuesPosition;
        }
    }

    private void addRawVector(IntVector valueVector, LongVector timestampVector, BooleanVector mask) {
        long timestampValue;
        int valueValue;
        int valuesPosition;
        for (valuesPosition = 0; !this.state.seen() && valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) {
                continue;
            }
            valueValue = valueVector.getInt(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstIntByTimestampAggregator.first(this.state, valueValue, timestampValue);
            ++valuesPosition;
            this.state.seen(true);
            break;
        }
        while (valuesPosition < valueVector.getPositionCount()) {
            if (!mask.getBoolean(valuesPosition)) {
                ++valuesPosition;
                continue;
            }
            valueValue = valueVector.getInt(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstIntByTimestampAggregator.combine(this.state, valueValue, timestampValue);
            ++valuesPosition;
        }
    }

    private void addRawBlock(IntBlock valueBlock, LongBlock timestampBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int timestampValueCount;
            int valueValueCount = valueBlock.getValueCount(p);
            if (valueValueCount == 0 || (timestampValueCount = timestampBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                int valueValue = valueBlock.getInt(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampValueCount;
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    if (this.state.seen()) {
                        FirstIntByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                        continue;
                    }
                    this.state.seen(true);
                    FirstIntByTimestampAggregator.first(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawBlock(IntBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int timestampValueCount;
            int valueValueCount;
            if (!mask.getBoolean(p) || (valueValueCount = valueBlock.getValueCount(p)) == 0 || (timestampValueCount = timestampBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                int valueValue = valueBlock.getInt(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampValueCount;
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    if (this.state.seen()) {
                        FirstIntByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                        continue;
                    }
                    this.state.seen(true);
                    FirstIntByTimestampAggregator.first(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + FirstIntByTimestampAggregatorFunction.intermediateStateDesc().size());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongVector timestamps = ((LongBlock)timestampsUncast).asVector();
        assert (timestamps.getPositionCount() == 1);
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        IntVector values = ((IntBlock)valuesUncast).asVector();
        assert (values.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        FirstIntByTimestampAggregator.combineIntermediate(this.state, timestamps.getLong(0), values.getInt(0), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = FirstIntByTimestampAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

