/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramBlockBuilder;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramBuilder;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramMerger;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;

public final class ExponentialHistogramStates {
    public static final int MAX_BUCKET_COUNT = 320;

    private ExponentialHistogramStates() {
    }

    public static final class WithLongGroupingState
    implements GroupingAggregatorState {
        private LongArray longValues;
        private ObjectArray<ReleasableExponentialHistogram> histogramValues;
        private final HistoBreaker breaker;
        private final BigArrays bigArrays;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        WithLongGroupingState(BigArrays bigArrays, CircuitBreaker breaker) {
            ObjectArray histogramValues;
            LongArray longValues;
            block3: {
                longValues = null;
                histogramValues = null;
                boolean success = false;
                try {
                    longValues = bigArrays.newLongArray(1L);
                    histogramValues = bigArrays.newObjectArray(1L);
                    success = true;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close((Releasable[])new Releasable[]{histogramValues, longValues});
                    }
                    throw throwable;
                }
                Releasables.close((Releasable[])new Releasable[]{histogramValues, longValues});
            }
            this.longValues = longValues;
            this.histogramValues = histogramValues;
            this.bigArrays = bigArrays;
            this.breaker = new HistoBreaker(breaker);
        }

        public void set(int groupId, long longValue, ExponentialHistogram histogramValue) {
            assert (histogramValue != null);
            this.ensureCapacity(groupId);
            try (ExponentialHistogramBuilder copyBuilder = ExponentialHistogram.builder((ExponentialHistogram)histogramValue, (ExponentialHistogramCircuitBreaker)this.breaker);){
                ReleasableExponentialHistogram old = (ReleasableExponentialHistogram)this.histogramValues.getAndSet((long)groupId, (Object)copyBuilder.build());
                Releasables.close((Releasable)old);
            }
            this.longValues.set((long)groupId, longValue);
        }

        private void ensureCapacity(int groupId) {
            this.histogramValues = this.bigArrays.grow(this.histogramValues, (long)(groupId + 1));
            this.longValues = this.bigArrays.grow(this.longValues, (long)(groupId + 1));
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 3);
            try (LongVector.FixedBuilder longBuilder = driverContext.blockFactory().newLongVectorFixedBuilder(selected.getPositionCount());
                 ExponentialHistogramBlockBuilder histoBuilder = driverContext.blockFactory().newExponentialHistogramBlockBuilder(selected.getPositionCount());
                 BooleanVector.FixedBuilder seenBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    if (this.seen(groupId)) {
                        seenBuilder.appendBoolean(true);
                        longBuilder.appendLong(this.longValues.get((long)groupId));
                        histoBuilder.append((ExponentialHistogram)this.histogramValues.get((long)groupId));
                        continue;
                    }
                    seenBuilder.appendBoolean(false);
                    longBuilder.appendLong(0L);
                    histoBuilder.append(ExponentialHistogram.empty());
                }
                blocks[offset] = longBuilder.build().asBlock();
                blocks[offset + 1] = histoBuilder.build();
                blocks[offset + 2] = seenBuilder.build().asBlock();
            }
        }

        public boolean seen(int groupId) {
            return (long)groupId < this.histogramValues.size() && this.histogramValues.get((long)groupId) != null;
        }

        public long longValue(int groupId) {
            assert (this.seen(groupId));
            return this.longValues.get((long)groupId);
        }

        public void close() {
            int i = 0;
            while ((long)i < this.histogramValues.size()) {
                Releasables.close((Releasable)((Releasable)this.histogramValues.get((long)i)));
                ++i;
            }
            Releasables.close((Releasable[])new Releasable[]{this.histogramValues, this.longValues});
            this.histogramValues = null;
            this.longValues = null;
        }

        public Block evaluateFinalHistograms(IntVector selected, DriverContext driverContext) {
            try (ExponentialHistogramBlockBuilder builder = driverContext.blockFactory().newExponentialHistogramBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    if (this.seen(groupId)) {
                        builder.append((ExponentialHistogram)this.histogramValues.get((long)groupId));
                        continue;
                    }
                    builder.appendNull();
                }
                ExponentialHistogramBlock exponentialHistogramBlock = builder.build();
                return exponentialHistogramBlock;
            }
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    public static final class WithLongSingleState
    implements AggregatorState {
        private final CircuitBreaker breaker;
        private long longValue;
        private ReleasableExponentialHistogram histogramValue;

        public WithLongSingleState(CircuitBreaker breaker) {
            this.breaker = breaker;
        }

        public boolean isSeen() {
            return this.histogramValue != null;
        }

        public long longValue() {
            assert (this.isSeen());
            return this.longValue;
        }

        public ReleasableExponentialHistogram histogramValue() {
            assert (this.isSeen());
            return this.histogramValue;
        }

        public void set(long longValue, ExponentialHistogram histogram) {
            ReleasableExponentialHistogram newValue;
            assert (histogram != null);
            this.longValue = longValue;
            try (ExponentialHistogramBuilder copyBuilder = ExponentialHistogram.builder((ExponentialHistogram)histogram, (ExponentialHistogramCircuitBreaker)new HistoBreaker(this.breaker));){
                newValue = copyBuilder.build();
            }
            Releasables.close((Releasable)this.histogramValue);
            this.histogramValue = newValue;
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 3);
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.histogramValue == null) {
                blocks[offset] = blockFactory.newConstantLongBlockWith(0L, 1);
                blocks[offset + 1] = blockFactory.newConstantExponentialHistogramBlock(ExponentialHistogram.empty(), 1);
                blocks[offset + 2] = blockFactory.newConstantBooleanBlockWith(false, 1);
            } else {
                blocks[offset] = blockFactory.newConstantLongBlockWith(this.longValue, 1);
                blocks[offset + 1] = blockFactory.newConstantExponentialHistogramBlock((ExponentialHistogram)this.histogramValue, 1);
                blocks[offset + 2] = blockFactory.newConstantBooleanBlockWith(true, 1);
            }
        }

        public Block evaluateFinalHistogram(DriverContext driverContext) {
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.histogramValue == null) {
                return blockFactory.newConstantNullBlock(1);
            }
            return blockFactory.newConstantExponentialHistogramBlock((ExponentialHistogram)this.histogramValue, 1);
        }

        public void close() {
            Releasables.close((Releasable)this.histogramValue);
            this.histogramValue = null;
        }
    }

    static final class GroupingState
    implements GroupingAggregatorState {
        private ObjectArray<ExponentialHistogramMerger> states;
        private final HistoBreaker breaker;
        private final BigArrays bigArrays;

        GroupingState(BigArrays bigArrays, CircuitBreaker breaker) {
            this.states = bigArrays.newObjectArray(1L);
            this.bigArrays = bigArrays;
            this.breaker = new HistoBreaker(breaker);
        }

        ExponentialHistogramMerger getOrNull(int position) {
            if ((long)position < this.states.size()) {
                return (ExponentialHistogramMerger)this.states.get((long)position);
            }
            return null;
        }

        public void add(int groupId, ExponentialHistogram histogram, boolean allowUpscale) {
            if (histogram == null) {
                return;
            }
            this.ensureCapacity(groupId);
            ExponentialHistogramMerger state = (ExponentialHistogramMerger)this.states.get((long)groupId);
            if (state == null) {
                state = ExponentialHistogramMerger.create((int)320, (ExponentialHistogramCircuitBreaker)this.breaker);
                this.states.set((long)groupId, (Object)state);
            }
            if (allowUpscale) {
                state.add(histogram);
            } else {
                state.addWithoutUpscaling(histogram);
            }
        }

        private void ensureCapacity(int groupId) {
            this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 2) : "blocks=" + blocks.length + ",offset=" + offset;
            try (ExponentialHistogramBlockBuilder histoBuilder = driverContext.blockFactory().newExponentialHistogramBlockBuilder(selected.getPositionCount());
                 BooleanBlock.Builder seenBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    ExponentialHistogramMerger state = this.getOrNull(groupId);
                    if (state != null) {
                        seenBuilder.appendBoolean(true);
                        histoBuilder.append(state.get());
                        continue;
                    }
                    seenBuilder.appendBoolean(false);
                    histoBuilder.append(ExponentialHistogram.empty());
                }
                blocks[offset] = histoBuilder.build();
                blocks[offset + 1] = seenBuilder.build();
            }
        }

        public Block evaluateFinal(IntVector selected, DriverContext driverContext) {
            try (ExponentialHistogramBlockBuilder builder = driverContext.blockFactory().newExponentialHistogramBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    ExponentialHistogramMerger state = this.getOrNull(groupId);
                    if (state != null) {
                        builder.append(state.get());
                        continue;
                    }
                    builder.appendNull();
                }
                ExponentialHistogramBlock exponentialHistogramBlock = builder.build();
                return exponentialHistogramBlock;
            }
        }

        public void close() {
            int i = 0;
            while ((long)i < this.states.size()) {
                Releasables.close((Releasable)((Releasable)this.states.get((long)i)));
                ++i;
            }
            Releasables.close(this.states);
            this.states = null;
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    static final class SingleState
    implements AggregatorState {
        private final CircuitBreaker breaker;
        private ExponentialHistogramMerger merger;

        SingleState(CircuitBreaker breaker) {
            this.breaker = breaker;
        }

        public void add(ExponentialHistogram histogram, boolean allowUpscale) {
            if (histogram == null) {
                return;
            }
            if (this.merger == null) {
                this.merger = ExponentialHistogramMerger.create((int)320, (ExponentialHistogramCircuitBreaker)new HistoBreaker(this.breaker));
            }
            if (allowUpscale) {
                this.merger.add(histogram);
            } else {
                this.merger.addWithoutUpscaling(histogram);
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 2);
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.merger == null) {
                blocks[offset] = blockFactory.newConstantExponentialHistogramBlock(ExponentialHistogram.empty(), 1);
                blocks[offset + 1] = blockFactory.newConstantBooleanBlockWith(false, 1);
            } else {
                blocks[offset] = blockFactory.newConstantExponentialHistogramBlock(this.merger.get(), 1);
                blocks[offset + 1] = blockFactory.newConstantBooleanBlockWith(true, 1);
            }
        }

        public void close() {
            Releasables.close((Releasable)this.merger);
            this.merger = null;
        }

        public Block evaluateFinal(DriverContext driverContext) {
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.merger == null) {
                return blockFactory.newConstantNullBlock(1);
            }
            return blockFactory.newConstantExponentialHistogramBlock(this.merger.get(), 1);
        }
    }

    private record HistoBreaker(CircuitBreaker delegate) implements ExponentialHistogramCircuitBreaker
    {
        public void adjustBreaker(long bytesAllocated) {
            if (bytesAllocated < 0L) {
                this.delegate.addWithoutBreaking(bytesAllocated);
            } else {
                this.delegate.addEstimateBytesAndMaybeBreak(bytesAllocated, "ExponentialHistogram aggregation state");
            }
        }
    }
}

