/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class AbstractRateGroupingFunction {
    AbstractRateGroupingFunction() {
    }

    static final class FlushQueue
    extends PriorityQueue<Slice> {
        int valueCount;

        FlushQueue(int maxSize) {
            super(maxSize);
        }

        long secondNextTimestamp() {
            Object[] heap = this.getHeapArray();
            int size = this.size();
            if (size == 2) {
                return ((Slice)heap[2]).nextTimestamp;
            }
            if (size >= 3) {
                return Math.max(((Slice)heap[2]).nextTimestamp, ((Slice)heap[3]).nextTimestamp);
            }
            return Long.MIN_VALUE;
        }

        protected boolean lessThan(Slice a, Slice b) {
            return a.nextTimestamp > b.nextTimestamp;
        }
    }

    static final class Slice {
        int start;
        int end;
        long nextTimestamp;
        private long lastTimestamp = Long.MAX_VALUE;
        final LongArray timestamps;

        Slice(LongArray timestamps, int start, int end) {
            this.timestamps = timestamps;
            this.start = start;
            this.end = end;
            this.nextTimestamp = timestamps.get((long)start);
        }

        boolean exhausted() {
            return this.start >= this.end;
        }

        int next() {
            int currentIndex = this.start++;
            if (this.start < this.end) {
                this.nextTimestamp = this.timestamps.get((long)this.start);
            }
            return currentIndex;
        }

        long lastTimestamp() {
            if (this.lastTimestamp == Long.MAX_VALUE) {
                this.lastTimestamp = this.timestamps.get((long)(this.end - 1));
            }
            return this.lastTimestamp;
        }
    }

    record FlushQueues(RawBuffer buffer, int minGroupId, int maxGroupId, int[] runningOffsets, IntArray sliceOffsets) implements Releasable
    {
        FlushQueue getFlushQueue(int groupId) {
            if (groupId < this.minGroupId || groupId > this.maxGroupId) {
                return null;
            }
            int groupIndex = groupId - this.minGroupId;
            int endIndex = this.runningOffsets[groupIndex];
            int startIndex = groupIndex == 0 ? 0 : this.runningOffsets[groupIndex - 1];
            int numSlices = endIndex - startIndex;
            if (numSlices == 0) {
                return null;
            }
            FlushQueue queue = new FlushQueue(numSlices);
            for (int i = startIndex; i < endIndex; ++i) {
                int end;
                int start = this.sliceOffsets.get((long)i * 2L);
                if (start >= (end = this.sliceOffsets.get((long)i * 2L + 1L))) continue;
                queue.valueCount += end - start;
                queue.add(new Slice(this.buffer.timestamps, start, end));
            }
            if (queue.valueCount == 0) {
                return null;
            }
            return queue;
        }

        public void close() {
            Releasables.close((Releasable)this.sliceOffsets);
        }
    }

    static abstract class RawBuffer
    implements Releasable {
        final BigArrays bigArrays;
        LongArray timestamps;
        int valueCount;
        IntArray sliceStarts;
        IntArray sliceGroupIds;
        int sliceCount;
        int lastGroupId = -1;
        int minGroupId = Integer.MAX_VALUE;
        int maxGroupId = Integer.MIN_VALUE;

        RawBuffer(BigArrays bigArrays) {
            this.bigArrays = bigArrays;
            boolean success = false;
            try {
                this.timestamps = bigArrays.newLongArray(2048L, false);
                this.sliceStarts = bigArrays.newIntArray(512L, false);
                this.sliceGroupIds = bigArrays.newIntArray(512L, false);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        final void prepareSlicesOnly(int groupId, long firstTimestamp) {
            if (this.lastGroupId == groupId && this.valueCount > 0 && this.timestamps.get((long)(this.valueCount - 1)) > firstTimestamp) {
                return;
            }
            this.sliceStarts = this.bigArrays.grow(this.sliceStarts, (long)this.sliceCount + 1L);
            this.sliceGroupIds = this.bigArrays.grow(this.sliceGroupIds, (long)this.sliceCount + 1L);
            if (groupId < this.minGroupId) {
                this.minGroupId = groupId;
            }
            if (groupId > this.maxGroupId) {
                this.maxGroupId = groupId;
            }
            this.sliceStarts.set((long)this.sliceCount, this.valueCount);
            this.sliceGroupIds.set((long)this.sliceCount, groupId);
            this.lastGroupId = groupId;
            ++this.sliceCount;
        }

        final FlushQueues prepareForFlush() {
            if (this.minGroupId > this.maxGroupId) {
                return new FlushQueues(this, this.minGroupId, this.maxGroupId, null, null);
            }
            int numGroups = this.maxGroupId - this.minGroupId + 1;
            int[] runningOffsets = new int[numGroups];
            for (int i = 0; i < this.sliceCount; ++i) {
                int groupIndex;
                int n = groupIndex = this.sliceGroupIds.get((long)i) - this.minGroupId;
                runningOffsets[n] = runningOffsets[n] + 1;
            }
            int runningOffset = 0;
            for (int i = 0; i < numGroups; ++i) {
                int count = runningOffsets[i];
                runningOffsets[i] = runningOffset;
                runningOffset += count;
            }
            IntArray sliceOffsets = this.bigArrays.newIntArray((long)this.sliceCount * 2L, false);
            for (int i = 0; i < this.sliceCount; ++i) {
                int dstIndex;
                int groupIndex = this.sliceGroupIds.get((long)i) - this.minGroupId;
                int startOffset = this.sliceStarts.get((long)i);
                int endOffset = i + 1 < this.sliceCount ? this.sliceStarts.get((long)(i + 1)) : this.valueCount;
                int n = groupIndex;
                runningOffsets[n] = runningOffsets[n] + 1;
                sliceOffsets.set((long)dstIndex * 2L, startOffset);
                sliceOffsets.set((long)dstIndex * 2L + 1L, endOffset);
            }
            this.valueCount = 0;
            this.sliceCount = 0;
            this.lastGroupId = -1;
            return new FlushQueues(this, this.minGroupId, this.maxGroupId, runningOffsets, sliceOffsets);
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.timestamps, this.sliceStarts, this.sliceGroupIds});
        }
    }
}

