/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public class TDigestParser {
    public static final String CENTROIDS_NAME = "centroids";
    public static final String COUNTS_NAME = "counts";
    public static final String SUM_FIELD_NAME = "sum";
    public static final String MIN_FIELD_NAME = "min";
    public static final String MAX_FIELD_NAME = "max";
    private static final ParseField COUNTS_FIELD = new ParseField("counts", new String[0]);
    private static final ParseField CENTROIDS_FIELD = new ParseField("centroids", new String[0]);
    private static final ParseField SUM_FIELD = new ParseField("sum", new String[0]);
    private static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ParseField MIN_FIELD = new ParseField("min", new String[0]);

    public static ParsedTDigest parse(String mappedFieldName, XContentParser parser, BiFunction<XContentLocation, String, RuntimeException> documentParsingExceptionProvider, ParsingExceptionProvider parsingExceptionProvider) throws IOException {
        ArrayList<Double> centroids = null;
        ArrayList<Long> counts = null;
        Double sum = null;
        Double min = null;
        Double max = null;
        XContentParser.Token token = parser.currentToken();
        while (token != XContentParser.Token.END_OBJECT) {
            TDigestParser.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser, parsingExceptionProvider);
            String fieldName = parser.currentName();
            if (fieldName.equals(CENTROIDS_FIELD.getPreferredName())) {
                centroids = TDigestParser.getCentroids(mappedFieldName, parser, documentParsingExceptionProvider, parsingExceptionProvider);
            } else if (fieldName.equals(COUNTS_FIELD.getPreferredName())) {
                counts = TDigestParser.getCounts(mappedFieldName, parser, documentParsingExceptionProvider, parsingExceptionProvider);
            } else if (fieldName.equals(SUM_FIELD.getPreferredName())) {
                token = parser.nextToken();
                TDigestParser.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser, parsingExceptionProvider);
                sum = parser.doubleValue();
            } else if (fieldName.equals(MIN_FIELD.getPreferredName())) {
                token = parser.nextToken();
                TDigestParser.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser, parsingExceptionProvider);
                min = parser.doubleValue();
            } else if (fieldName.equals(MAX_FIELD.getPreferredName())) {
                token = parser.nextToken();
                TDigestParser.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser, parsingExceptionProvider);
                max = parser.doubleValue();
            } else {
                throw documentParsingExceptionProvider.apply(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], with unknown parameter [" + fieldName + "]");
            }
            token = parser.nextToken();
        }
        if (centroids == null) {
            throw documentParsingExceptionProvider.apply(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + CENTROIDS_FIELD.getPreferredName() + "]");
        }
        if (counts == null) {
            throw documentParsingExceptionProvider.apply(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + COUNTS_FIELD.getPreferredName() + "]");
        }
        if (centroids.size() != counts.size()) {
            throw documentParsingExceptionProvider.apply(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected same length from [" + CENTROIDS_FIELD.getPreferredName() + "] and [" + COUNTS_FIELD.getPreferredName() + "] but got [" + centroids.size() + " != " + counts.size() + "]");
        }
        if (centroids.isEmpty()) {
            sum = null;
            min = null;
            max = null;
        }
        return new ParsedTDigest(centroids, (List<Long>)counts, sum, min, max);
    }

    private static ArrayList<Long> getCounts(String mappedFieldName, XContentParser parser, BiFunction<XContentLocation, String, RuntimeException> documentParsingExceptionProvider, ParsingExceptionProvider parsingExceptionProvider) throws IOException {
        XContentParser.Token token = parser.nextToken();
        TDigestParser.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser, parsingExceptionProvider);
        ArrayList<Long> counts = new ArrayList<Long>();
        token = parser.nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            TDigestParser.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser, parsingExceptionProvider);
            long count = parser.longValue();
            if (count < 0L) {
                throw documentParsingExceptionProvider.apply(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], [" + String.valueOf(COUNTS_FIELD) + "] elements must be >= 0 but got " + count);
            }
            counts.add(count);
            token = parser.nextToken();
        }
        return counts;
    }

    private static ArrayList<Double> getCentroids(String mappedFieldName, XContentParser parser, BiFunction<XContentLocation, String, RuntimeException> documentParsingExceptionProvider, ParsingExceptionProvider parsingExceptionProvider) throws IOException {
        XContentParser.Token token = parser.nextToken();
        TDigestParser.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser, parsingExceptionProvider);
        ArrayList<Double> centroids = new ArrayList<Double>();
        token = parser.nextToken();
        double previousVal = -1.7976931348623157E308;
        while (token != XContentParser.Token.END_ARRAY) {
            TDigestParser.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser, parsingExceptionProvider);
            double val = parser.doubleValue();
            if (val < previousVal) {
                throw documentParsingExceptionProvider.apply(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], [" + String.valueOf(CENTROIDS_FIELD) + "] centroids must be in increasing order, got [" + val + "] but previous value was [" + previousVal + "]");
            }
            centroids.add(val);
            previousVal = val;
            token = parser.nextToken();
        }
        return centroids;
    }

    public static void ensureExpectedToken(XContentParser.Token expected, XContentParser.Token actual, XContentParser parser, ParsingExceptionProvider parsingExceptionProvider) throws IOException {
        if (actual != expected) {
            throw parsingExceptionProvider.apply(parser, expected, actual);
        }
    }

    @FunctionalInterface
    public static interface ParsingExceptionProvider {
        public RuntimeException apply(XContentParser var1, XContentParser.Token var2, XContentParser.Token var3) throws IOException;
    }

    public record ParsedTDigest(List<Double> centroids, List<Long> counts, Double sum, Double min, Double max) {
        private final Double sum;
        private final Double min;
        private final Double max;

        public Double max() {
            if (this.max != null) {
                return this.max;
            }
            if (this.centroids != null && !this.centroids.isEmpty()) {
                return this.centroids.get(this.centroids.size() - 1);
            }
            return Double.NaN;
        }

        public Double min() {
            if (this.min != null) {
                return this.min;
            }
            if (this.centroids != null && !this.centroids.isEmpty()) {
                return this.centroids.get(0);
            }
            return Double.NaN;
        }

        public Double sum() {
            if (this.sum != null) {
                return this.sum;
            }
            if (this.centroids != null && !this.centroids.isEmpty()) {
                double observedSum = 0.0;
                for (int i = 0; i < this.centroids.size(); ++i) {
                    observedSum += this.centroids.get(i) * (double)this.counts.get(i).longValue();
                }
                return observedSum;
            }
            return Double.NaN;
        }

        public Long count() {
            if (this.counts != null && !this.counts.isEmpty()) {
                long observedCount = 0L;
                for (Long count : this.counts) {
                    observedCount += count.longValue();
                }
                return observedCount;
            }
            return 0L;
        }
    }
}

