/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.Random;
import org.elasticsearch.tdigest.arrays.TDigestDoubleArray;
import org.elasticsearch.tdigest.arrays.TDigestIntArray;

public class Sort {
    private static final Random prng = new Random();

    public static void stableSort(TDigestIntArray order, TDigestDoubleArray values, int n) {
        for (int i = 0; i < n; ++i) {
            order.set(i, i);
        }
        Sort.stableQuickSort(order, values, 0, n, 64);
        Sort.stableInsertionSort(order, values, 0, n, 64);
    }

    private static void stableQuickSort(TDigestIntArray order, TDigestDoubleArray values, int start, int end, int limit) {
        while (end - start > limit) {
            int pivotIndex = start + prng.nextInt(end - start);
            double pivotValue = values.get(order.get(pivotIndex));
            int pv = order.get(pivotIndex);
            Sort.swap(order, start, pivotIndex);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = values.get(order.get(i));
                int pi = order.get(i);
                if (vi == pivotValue && pi == pv) {
                    if (low != i) {
                        Sort.swap(order, low, i);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                int c = Double.compare(vi, pivotValue);
                if (c > 0 || c == 0 && pi > pv) {
                    Sort.swap(order, i, --high);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                Sort.swap(order, from++, to--);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                Sort.stableQuickSort(order, values, start, low, limit);
                start = high;
                continue;
            }
            Sort.stableQuickSort(order, values, high, end, limit);
            end = low;
        }
    }

    private static void swap(TDigestIntArray order, int i, int j) {
        int t = order.get(i);
        order.set(i, order.get(j));
        order.set(j, t);
    }

    private static void stableInsertionSort(TDigestIntArray order, TDigestDoubleArray values, int start, int n, int limit) {
        block0: for (int i = start + 1; i < n; ++i) {
            int t = order.get(i);
            double v = values.get(order.get(i));
            int vi = order.get(i);
            int m = Math.max(i - limit, start);
            for (int j = i; j >= m; --j) {
                int c;
                int n2 = c = j == 0 ? -1 : Double.compare(values.get(order.get(j - 1)), v);
                if (c >= 0 && (c != 0 || order.get(j - 1) > vi)) continue;
                if (j >= i) continue block0;
                order.set(j + 1, order, j, i - j);
                order.set(j, t);
                continue block0;
            }
        }
    }

    public static void reverse(TDigestIntArray order, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            int t = order.get(offset + i);
            order.set(offset + i, order.get(offset + length - i - 1));
            order.set(offset + length - i - 1, t);
        }
    }

    public static void reverse(TDigestDoubleArray order, int offset, int length) {
        for (int i = 0; i < length / 2; ++i) {
            double t = order.get(offset + i);
            order.set(offset + i, order.get(offset + length - i - 1));
            order.set(offset + length - i - 1, t);
        }
    }
}

