/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.Header;
import org.elasticsearch.transport.InboundAggregator;
import org.elasticsearch.transport.InboundDecoder;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.TcpChannel;

public class InboundPipeline
implements Releasable {
    private static final InboundMessage PING_MESSAGE = new InboundMessage(null, true);
    private final LongSupplier relativeTimeInMillis;
    private final StatsTracker statsTracker;
    private final InboundDecoder decoder;
    private final InboundAggregator aggregator;
    private final BiConsumer<TcpChannel, InboundMessage> messageHandler;
    private Exception uncaughtException;
    private final ArrayDeque<ReleasableBytesReference> pending = new ArrayDeque(2);
    private boolean isClosed = false;

    public InboundPipeline(StatsTracker statsTracker, LongSupplier relativeTimeInMillis, InboundDecoder decoder, InboundAggregator aggregator, BiConsumer<TcpChannel, InboundMessage> messageHandler) {
        this.relativeTimeInMillis = relativeTimeInMillis;
        this.statsTracker = statsTracker;
        this.decoder = decoder;
        this.aggregator = aggregator;
        this.messageHandler = messageHandler;
    }

    public void close() {
        this.isClosed = true;
        Releasable[] releasableArray = new Releasable[4];
        releasableArray[0] = this.decoder;
        releasableArray[1] = this.aggregator;
        releasableArray[2] = () -> Releasables.close(this.pending);
        releasableArray[3] = this.pending::clear;
        Releasables.closeExpectNoException((Releasable[])releasableArray);
    }

    public void handleBytes(TcpChannel channel, ReleasableBytesReference reference) throws IOException {
        if (this.uncaughtException != null) {
            reference.close();
            throw new IllegalStateException("Pipeline state corrupted by uncaught exception", this.uncaughtException);
        }
        try {
            channel.getChannelStats().markAccessed(this.relativeTimeInMillis.getAsLong());
            this.statsTracker.markBytesRead(reference.length());
            if (this.isClosed) {
                reference.close();
                return;
            }
            this.pending.add(reference);
            this.doHandleBytes(channel);
        }
        catch (Exception e) {
            this.uncaughtException = e;
            throw e;
        }
    }

    private void doHandleBytes(TcpChannel channel) throws IOException {
        do {
            CheckedConsumer decodeConsumer = f -> this.forwardFragment(channel, f);
            int bytesDecoded = this.decoder.decode(this.pending.peekFirst(), (CheckedConsumer<Object, IOException>)decodeConsumer);
            if (bytesDecoded == 0 && this.pending.size() > 1) {
                BytesReference[] bytesReferences = new ReleasableBytesReference[this.pending.size()];
                int index = 0;
                for (ReleasableBytesReference pendingReference : this.pending) {
                    bytesReferences[index] = pendingReference.retain();
                    ++index;
                }
                try (ReleasableBytesReference toDecode = new ReleasableBytesReference(CompositeBytesReference.of(bytesReferences), () -> InboundPipeline.lambda$doHandleBytes$2((ReleasableBytesReference[])bytesReferences));){
                    bytesDecoded = this.decoder.decode(toDecode, (CheckedConsumer<Object, IOException>)decodeConsumer);
                }
            }
            if (bytesDecoded == 0) break;
            this.releasePendingBytes(bytesDecoded);
        } while (!this.pending.isEmpty());
    }

    private void forwardFragment(TcpChannel channel, Object fragment) throws IOException {
        if (fragment instanceof Header) {
            this.headerReceived((Header)fragment);
        } else if (fragment instanceof Compression.Scheme) {
            assert (this.aggregator.isAggregating());
            this.aggregator.updateCompressionScheme((Compression.Scheme)((Object)fragment));
        } else if (fragment == InboundDecoder.PING) {
            assert (!this.aggregator.isAggregating());
            this.messageHandler.accept(channel, PING_MESSAGE);
        } else if (fragment == InboundDecoder.END_CONTENT) {
            assert (this.aggregator.isAggregating());
            this.statsTracker.markMessageReceived();
            this.messageHandler.accept(channel, this.aggregator.finishAggregation());
        } else {
            assert (this.aggregator.isAggregating());
            assert (fragment instanceof ReleasableBytesReference);
            this.aggregator.aggregate((ReleasableBytesReference)fragment);
        }
    }

    protected void headerReceived(Header header) {
        assert (!this.aggregator.isAggregating());
        this.aggregator.headerReceived(header);
    }

    private void releasePendingBytes(int bytesConsumed) {
        int bytesToRelease = bytesConsumed;
        while (bytesToRelease != 0) {
            ReleasableBytesReference reference = this.pending.pollFirst();
            try {
                assert (reference != null);
                if (bytesToRelease < reference.length()) {
                    this.pending.addFirst(reference.retainedSlice(bytesToRelease, reference.length() - bytesToRelease));
                    bytesToRelease -= bytesToRelease;
                    continue;
                }
                bytesToRelease -= reference.length();
            }
            finally {
                if (reference == null) continue;
                reference.close();
            }
        }
    }

    private static /* synthetic */ void lambda$doHandleBytes$2(ReleasableBytesReference[] bytesReferences) {
        Releasables.closeExpectNoException((Releasable[])bytesReferences);
    }
}

