/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.elasticsearch.search.vectors.AdaptiveHnswQueueSaturationCollector;

class PatienceCollectorManager
implements KnnCollectorManager {
    private final KnnCollectorManager knnCollectorManager;

    PatienceCollectorManager(KnnCollectorManager knnCollectorManager) {
        this.knnCollectorManager = knnCollectorManager;
    }

    static KnnCollectorManager wrap(KnnCollectorManager knnCollectorManager) {
        return new PatienceCollectorManager(knnCollectorManager);
    }

    public KnnCollector newCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx) throws IOException {
        return new AdaptiveHnswQueueSaturationCollector(this.knnCollectorManager.newCollector(visitLimit, searchStrategy, ctx));
    }

    public KnnCollector newOptimisticCollector(int visitLimit, KnnSearchStrategy searchStrategy, LeafReaderContext ctx, int k) throws IOException {
        if (this.knnCollectorManager.isOptimistic()) {
            return new AdaptiveHnswQueueSaturationCollector(this.knnCollectorManager.newOptimisticCollector(visitLimit, searchStrategy, ctx, k));
        }
        return null;
    }

    public boolean isOptimistic() {
        return this.knnCollectorManager.isOptimistic();
    }
}

